/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.config.Config;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.ForestryResource;
import forestry.core.render.TextureManagerForestry;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class Ledger {
    protected static final int minWidth = 24;
    public static final int minHeight = 24;
    protected final int maxWidth;
    protected final int maxTextWidth;
    protected int maxHeight = 24;
    private static final ResourceLocation ledgerTextureRight = new ForestryResource("textures/gui/ledger.png");
    private static final ResourceLocation ledgerTextureLeft = new ForestryResource("textures/gui/ledger_left.png");
    private final LedgerManager manager;
    private final int fontColorHeader;
    private final int fontColorText;
    private final int fontColorSubheader;
    private final int overlayColor;
    private boolean open;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected float currentWidth = 24.0f;
    protected float currentHeight = 24.0f;
    private int x;
    private int y;
    private final ResourceLocation texture;
    private static final float msPerUpdate = 16.667f;
    private long lastUpdateTime = 0L;

    protected Ledger(LedgerManager manager, String name) {
        this(manager, name, true);
    }

    protected Ledger(LedgerManager manager, String name, boolean rightSide) {
        this.manager = manager;
        this.texture = rightSide ? ledgerTextureRight : ledgerTextureLeft;
        this.fontColorHeader = manager.gui.getFontColor().get("ledger." + name + ".header");
        this.fontColorSubheader = manager.gui.getFontColor().get("ledger." + name + ".subheader");
        this.fontColorText = manager.gui.getFontColor().get("ledger." + name + ".text");
        this.overlayColor = manager.gui.getFontColor().get("ledger." + name + ".background");
        this.maxWidth = Math.min(124, manager.getMaxWidth());
        this.maxTextWidth = this.maxWidth - 18;
    }

    public Rectangle getArea() {
        GuiForestry gui = this.manager.gui;
        return new Rectangle(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, (int)this.currentWidth, (int)this.currentHeight);
    }

    public void update() {
        long updateTime;
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = System.currentTimeMillis();
            updateTime = this.lastUpdateTime + (long)Math.round(16.667f);
        } else {
            updateTime = System.currentTimeMillis();
        }
        float moveAmount = (float)((long)Config.guiTabSpeed * (updateTime - this.lastUpdateTime)) / 16.667f;
        this.lastUpdateTime = updateTime;
        if (this.open && this.currentWidth < (float)this.maxWidth) {
            this.currentWidth += moveAmount;
            if (this.currentWidth > (float)this.maxWidth) {
                this.currentWidth = this.maxWidth;
            }
        } else if (!this.open && this.currentWidth > 24.0f) {
            this.currentWidth -= moveAmount;
            if (this.currentWidth < 24.0f) {
                this.currentWidth = 24.0f;
            }
        }
        if (this.open && this.currentHeight < (float)this.maxHeight) {
            this.currentHeight += moveAmount;
            if (this.currentHeight > (float)this.maxHeight) {
                this.currentHeight = this.maxHeight;
            }
        } else if (!this.open && this.currentHeight > 24.0f) {
            this.currentHeight -= moveAmount;
            if (this.currentHeight < 24.0f) {
                this.currentHeight = 24.0f;
            }
        }
    }

    public int getHeight() {
        return Math.round(this.currentHeight);
    }

    public int getWidth() {
        return Math.round(this.currentWidth);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public final void draw() {
        this.draw(this.x, this.y);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(int var1, int var2);

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersects(int mouseX, int mouseY) {
        return mouseX >= this.currentShiftX && (float)mouseX <= (float)this.currentShiftX + this.currentWidth && mouseY >= this.currentShiftY && mouseY <= this.currentShiftY + this.getHeight();
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionVars.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= (float)this.maxWidth;
    }

    public void onGuiClosed() {
    }

    protected void drawBackground(int x, int y) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        int height = this.getHeight();
        int width = this.getWidth();
        this.manager.gui.func_73729_b(x, y + 4, 0, 256 - height + 4, 4, height - 4);
        this.manager.gui.func_73729_b(x + 4, y, 256 - width + 4, 0, width - 4, 4);
        this.manager.gui.func_73729_b(x, y, 0, 0, 4, 4);
        this.manager.gui.func_73729_b(x + 4, y + 4, 256 - width + 4, 256 - height + 4, width - 4, height - 4);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawSprite(TextureAtlasSprite sprite, int x, int y) {
        this.drawSprite(TextureManagerForestry.getInstance().getGuiTextureMap(), sprite, x, y);
    }

    protected void drawSprite(ResourceLocation textureMap, TextureAtlasSprite sprite, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureMap);
        this.manager.gui.func_175175_a(x, y, sprite, 16, 16);
    }

    protected int drawHeader(String string, int x, int y) {
        return this.drawShadowText(string, x, y, this.fontColorHeader);
    }

    protected int drawSubheader(String string, int x, int y) {
        return this.drawShadowText(string, x, y, this.fontColorSubheader);
    }

    protected int drawShadowText(String string, int x, int y, int color) {
        return this.drawSplitText(string, x, y, this.maxTextWidth, color, true);
    }

    protected int drawSplitText(String string, int x, int y, int width) {
        return this.drawSplitText(string, x, y, width, this.fontColorText, false);
    }

    protected int drawSplitText(String string, int x, int y, int width, int color, boolean shadow) {
        int originalY = y;
        Minecraft minecraft = Minecraft.func_71410_x();
        List strings = minecraft.field_71466_p.func_78271_c(string, width);
        for (Object obj : strings) {
            if (!(obj instanceof String)) continue;
            minecraft.field_71466_p.func_175065_a((String)obj, (float)x, (float)y, color, shadow);
            y += minecraft.field_71466_p.field_78288_b;
        }
        return y - originalY;
    }

    protected int drawText(String string, int x, int y) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_78276_b(string, x, y, this.fontColorText);
        return minecraft.field_71466_p.field_78288_b;
    }
}

