/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.factory.gui;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryFabricator;
import forestry.factory.tiles.TileFabricator;

public class ContainerFabricator extends ContainerLiquidTanks<TileFabricator> implements IContainerCrafting {

	public ContainerFabricator(InventoryPlayer playerInventory, TileFabricator tile) {
		super(tile, playerInventory, 8, 129);

		// Internal inventory
		for (int i = 0; i < 2; i++) {
			for (int k = 0; k < 9; k++) {
				func_75146_a(new Slot(tile, InventoryFabricator.SLOT_INVENTORY_1 + k + i * 9, 8 + k * 18, 84 + i * 18));
			}
		}

		// Molten resource
		this.func_75146_a(new SlotFiltered(tile, InventoryFabricator.SLOT_METAL, 26, 21));

		// Plan
		this.func_75146_a(new SlotFiltered(tile, InventoryFabricator.SLOT_PLAN, 139, 17));

		// Result
		this.func_75146_a(new SlotOutput(tile, InventoryFabricator.SLOT_RESULT, 139, 53));

		// Crafting matrix
		for (int l = 0; l < 3; l++) {
			for (int k = 0; k < 3; k++) {
				func_75146_a(new SlotCraftMatrix(this, tile.getCraftingInventory(), InventoryGhostCrafting.SLOT_CRAFTING_1 + k + l * 3, 67 + k * 18, 17 + l * 18));
			}
		}
	}

	@Override
	public void onCraftMatrixChanged(IInventory iinventory, int slot) {

	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_75137_b(int messageId, int data) {
		super.func_75137_b(messageId, data);

		tile.getGUINetworkData(messageId, data);
	}

	@Override
	public void func_75142_b() {
		super.func_75142_b();

		for (IContainerListener crafter : field_75149_d) {
			tile.sendGUINetworkData(this, crafter);
		}
	}

	public TileFabricator getFabricator() {
		return tile;
	}
}
