/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import forestry.core.models.BlankModel;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ModelUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.BakedItemModel;

public class ModelCrateBaked
extends BlankModel {
    private ContentModel contentModel;

    ModelCrateBaked(List<BakedQuad> quads) {
        this.contentModel = new ContentModel(quads);
    }

    ModelCrateBaked(List<BakedQuad> quads, ItemStack content) {
        this.contentModel = new RawContentModel(quads, content);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.contentModel.hasBakedModel()) {
            this.contentModel = this.contentModel.bake();
        }
        return this.contentModel.getQuads();
    }

    private class RawContentModel
    extends ContentModel {
        private final ItemStack content;

        private RawContentModel(List<BakedQuad> quads, ItemStack content) {
            super(quads);
            this.content = content;
        }

        @Override
        public ContentModel bake() {
            IBakedModel bakedModel = ModelUtil.getModel(this.content);
            if (bakedModel != null) {
                if (bakedModel instanceof BakedItemModel) {
                    this.quads.addAll(new TRSRBakedModel(bakedModel, -0.0625f, 0.0f, 0.0625f, 0.5f).func_188616_a(null, null, 0L));
                    this.quads.addAll(new TRSRBakedModel(bakedModel, -0.0625f, 0.0f, -0.0625f, 0.5f).func_188616_a(null, null, 0L));
                } else {
                    this.quads.addAll(new TRSRBakedModel(bakedModel, -0.0625f, 0.0f, 0.0f, 0.5f).func_188616_a(null, null, 0L));
                }
            }
            return new ContentModel(this.quads);
        }

        @Override
        public boolean hasBakedModel() {
            return true;
        }
    }

    private class ContentModel {
        final List<BakedQuad> quads;

        private ContentModel(List<BakedQuad> quads) {
            this.quads = quads;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }

        public ContentModel bake() {
            return this;
        }

        public boolean hasBakedModel() {
            return false;
        }
    }
}

