/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks;

import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;

public class GreenhouseBlockCache
implements IStreamable {
    private HashMap<Long, Set<BlockPos>> positions = new HashMap();

    public void add(Long chunkPos, BlockPos position) {
        this.positions.computeIfAbsent(chunkPos, k -> new HashSet()).add(position);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInt(this.positions.size());
        for (Map.Entry<Long, Set<BlockPos>> entry : this.positions.entrySet()) {
            data.writeLong(entry.getKey());
            Set<BlockPos> chunkPositions = entry.getValue();
            data.writeInt(chunkPositions.size());
            for (BlockPos pos : chunkPositions) {
                data.func_179255_a(pos);
            }
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.positions.clear();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            long chunkPosition = data.readLong();
            int chunkSize = data.readInt();
            HashSet<BlockPos> chunkPositions = new HashSet<BlockPos>();
            for (int p = 0; p < chunkSize; ++p) {
                chunkPositions.add(data.func_179259_c());
            }
            this.positions.put(chunkPosition, chunkPositions);
        }
    }

    public HashMap<Long, Set<BlockPos>> getPositions() {
        return this.positions;
    }

    public void clear() {
        this.positions.clear();
    }
}

