/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.core.IErrorLogic;
import forestry.api.greenhouse.IClimateHousing;
import forestry.core.climate.ClimateStates;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.energy.EnergyManager;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.climate.ClimateSourceCircuitable;
import forestry.greenhouse.climate.ClimateSourceMode;
import forestry.greenhouse.climate.ClimateSourceType;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileClimatiser;

public class ClimateSourceClimatiser<O extends TileClimatiser>
extends ClimateSourceCircuitable<O> {
    protected static final int ENERGY_PER_OPERATION = 75;

    public ClimateSourceClimatiser(ClimateSourceType type, float change, float boundModifier) {
        super(change, boundModifier, type);
        if (type.canChangeTemperature()) {
            this.setTemperatureMode(change > 0.0f ? ClimateSourceMode.POSITIVE : ClimateSourceMode.NEGATIVE);
        } else {
            this.setHumidityMode(change > 0.0f ? ClimateSourceMode.POSITIVE : ClimateSourceMode.NEGATIVE);
        }
    }

    @Override
    public void onRemoved(IClimateContainer container) {
        super.onRemoved(container);
        ((TileClimatiser)this.owner).setActive(false);
    }

    @Override
    protected void isNotValid() {
        ((TileClimatiser)this.owner).setActive(false);
    }

    @Override
    public boolean canWork(IClimateState currentState, ClimateSourceType oppositeType) {
        IClimateHousing region = this.container.getParent();
        if (region instanceof IGreenhouseControllerInternal) {
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)region;
            IErrorLogic errorLogic = ((TileClimatiser)this.owner).getErrorLogic();
            EnergyManager energyManager = controller.getEnergyManager();
            if (energyManager.extractEnergy((int)(75.0f * this.getEnergyModifier(currentState, oppositeType)), true) > 0) {
                ((TileClimatiser)this.owner).setActive(true);
                errorLogic.setCondition(false, EnumErrorCode.NO_POWER);
                return true;
            }
            ((TileClimatiser)this.owner).setActive(false);
            errorLogic.setCondition(true, EnumErrorCode.NO_POWER);
            return false;
        }
        if (((TileClimatiser)this.owner).isActive()) {
            ((TileClimatiser)this.owner).setActive(false);
        }
        return false;
    }

    @Override
    protected void removeResources(IClimateState currentState, ClimateSourceType oppositeType) {
        IClimateHousing region = this.container.getParent();
        if (region instanceof IGreenhouseControllerInternal) {
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)region;
            EnergyManager energyManager = controller.getEnergyManager();
            energyManager.extractEnergy((int)(75.0f * this.getEnergyModifier(currentState, oppositeType)), false);
        }
    }

    protected float getEnergyModifier(IClimateState currentState, ClimateSourceType oppositeType) {
        float change = oppositeType == null ? 0.0f : (oppositeType.canChangeTemperature() ? currentState.getTemperature() : (oppositeType.canChangeHumidity() ? currentState.getHumidity() : 0.0f));
        return (1.0f + change) * Config.climateSourceEnergyModifier * this.energyChange;
    }

    @Override
    protected IClimateState getChange(ClimateSourceType type, IClimateState target, IClimateState currentState) {
        float temperature = 0.0f;
        float humidity = 0.0f;
        if (type.canChangeHumidity()) {
            humidity += this.getChange(ClimateType.HUMIDITY);
        }
        if (type.canChangeTemperature()) {
            temperature += this.getChange(ClimateType.TEMPERATURE);
        }
        return ClimateStates.extendedOf(temperature, humidity);
    }
}

