/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.bottler;

import forestry.factory.recipes.jei.bottler.BottlerRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BottlerRecipeMaker {
    private BottlerRecipeMaker() {
    }

    public static List<BottlerRecipeWrapper> getBottlerRecipes(IIngredientRegistry ingredientRegistry) {
        ArrayList<BottlerRecipeWrapper> recipes = new ArrayList<BottlerRecipeWrapper>();
        block0: for (ItemStack stack : ingredientRegistry.getAllIngredients(ItemStack.class)) {
            FluidStack drainedFluid;
            IFluidHandlerItem fluidHandler;
            if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (fluidHandler = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
            boolean canDrain = BottlerRecipeMaker.canDrain((IFluidHandler)fluidHandler);
            boolean canFill = BottlerRecipeMaker.canFill((IFluidHandler)fluidHandler);
            if (canDrain && (drainedFluid = fluidHandler.drain(Integer.MAX_VALUE, true)) != null) {
                ItemStack drained = fluidHandler.getContainer();
                recipes.add(new BottlerRecipeWrapper(stack, drainedFluid, drained, false));
            }
            if (!canFill) continue;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                IFluidHandlerItem fillingCapability = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fillingCapability == null) continue block0;
                int fill = fillingCapability.fill(new FluidStack(fluid, Integer.MAX_VALUE), true);
                if (fill <= 0) continue;
                FluidStack filledFluid = new FluidStack(fluid, fill);
                ItemStack filled = fillingCapability.getContainer();
                recipes.add(new BottlerRecipeWrapper(stack, filledFluid, filled, true));
            }
        }
        return recipes;
    }

    private static boolean canDrain(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) continue;
            return true;
        }
        return false;
    }

    private static boolean canFill(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canFill()) continue;
            return true;
        }
        return false;
    }
}

