/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.circuits;

import forestry.core.circuits.Circuit;
import forestry.core.circuits.ISpeedUpgradable;

public class CircuitSpeedUpgrade
extends Circuit {
    private final double speedBoost;
    private final float powerDraw;

    public CircuitSpeedUpgrade(String uid, double speedBoost, float powerDraw) {
        super(uid);
        this.speedBoost = speedBoost;
        this.powerDraw = powerDraw;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof ISpeedUpgradable;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        if (tile instanceof ISpeedUpgradable) {
            ISpeedUpgradable machine = (ISpeedUpgradable)tile;
            machine.applySpeedUpgrade(this.speedBoost, this.powerDraw);
        }
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        if (tile instanceof ISpeedUpgradable) {
            ISpeedUpgradable machine = (ISpeedUpgradable)tile;
            machine.applySpeedUpgrade(-this.speedBoost, -this.powerDraw);
        }
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

