/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.farming.IFarmInventory;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryUtil;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarmHatch;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TriggerLowSoil
extends Trigger {
    private final int threshold;

    public TriggerLowSoil(int threshold) {
        super("lowSoil." + threshold, "lowSoil", "low_soil");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        IStatementParameter parameter = null;
        if (parameters.length > 0) {
            parameter = parameters[0];
        }
        if (!(tile instanceof TileFarmHatch)) {
            return false;
        }
        TileFarmHatch tileHatch = (TileFarmHatch)tile;
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)tileHatch.getMultiblockLogic()).getController();
        IFarmInventory farmInventory = farmController.getFarmInventory();
        if (parameter == null || parameter.getItemStack().func_190926_b()) {
            IInventory resourcesInventory = farmInventory.getResourcesInventory();
            return InventoryUtil.containsPercent(resourcesInventory, this.threshold);
        }
        ItemStack filter = parameter.getItemStack().func_77946_l();
        filter.func_190920_e(this.threshold);
        return farmInventory.hasResources((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{filter}));
    }
}

