/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.trigger;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.core.IErrorLogicSource;
import forestry.core.errors.EnumErrorCode;
import forestry.core.triggers.Trigger;

public class TriggerMissingQueen extends Trigger {

	public TriggerMissingQueen() {
		super("missingQueen", "missing_queen");
	}

	/**
	 * Return true if the tile given in parameter activates the trigger, given the parameters.
	 */
	@Override
	public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {

		if (!(tile instanceof IErrorLogicSource)) {
			return false;
		}

		IErrorLogicSource apiary = (IErrorLogicSource) tile;
		return apiary.getErrorLogic().contains(EnumErrorCode.NO_QUEEN);
	}
}
