/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CamouflageUtil {
    @Nullable
    public static ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        TileEntity tile = TileUtil.getTile(world, pos, TileEntity.class);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            IMultiblockController controller;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            ICamouflageHandler handler = null;
            if (tile instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)tile;
            }
            if ((handler == null || handler.getCamouflageBlock().func_190926_b()) && tile instanceof IMultiblockComponent && (controller = (component = (IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
            }
            return handler;
        }
        return null;
    }

    public static ItemStack getCamouflageBlock(@Nullable IBlockAccess world, @Nullable BlockPos pos) {
        if (world == null || pos == null) {
            return ItemStack.field_190927_a;
        }
        TileEntity tile = TileUtil.getTile(world, pos, TileEntity.class);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            IMultiblockController controller;
            ItemStack defaultCamouflageStack;
            ICamouflageHandler tileHandler;
            ItemStack tileCamouflageStack;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            ItemStack camouflageStack = ItemStack.field_190927_a;
            if (tile instanceof ICamouflageHandler && !ItemStackUtil.isIdenticalItem(tileCamouflageStack = (tileHandler = (ICamouflageHandler)tile).getCamouflageBlock(), defaultCamouflageStack = tileHandler.getDefaultCamouflageBlock())) {
                camouflageStack = tileCamouflageStack;
            }
            if (camouflageStack.func_190926_b() && tile instanceof IMultiblockComponent && (controller = (component = (IMultiblockComponent)tile).getMultiblockLogic().getController()).isAssembled() && controller instanceof ICamouflageHandler) {
                ICamouflageHandler multiblockHandler = (ICamouflageHandler)((Object)controller);
                camouflageStack = multiblockHandler.getCamouflageBlock();
            }
            return camouflageStack;
        }
        return ItemStack.field_190927_a;
    }
}

