/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BlockUtil {
    private static final int slabWoodId = OreDictionary.getOreID((String)"slabWood");

    public static List<ItemStack> getBlockDrops(World world, BlockPos posBlock) {
        IBlockState blockState = world.func_180495_p(posBlock);
        return blockState.func_177230_c().getDrops((IBlockAccess)world, posBlock, blockState, 0);
    }

    public static boolean tryPlantCocoaPod(World world, BlockPos pos) {
        EnumFacing facing = BlockUtil.getValidPodFacing(world, pos);
        if (facing == null) {
            return false;
        }
        IBlockState state = Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing);
        world.func_175656_a(pos, state);
        return true;
    }

    @Nullable
    public static EnumFacing getValidPodFacing(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockUtil.isValidPodLocation(world, pos, facing)) continue;
            return facing;
        }
        return null;
    }

    public static boolean isValidPodLocation(World world, BlockPos pos, EnumFacing direction) {
        if (!world.func_175667_e(pos = pos.func_177972_a(direction))) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150364_r) {
            return state.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
        }
        return block.isWood((IBlockAccess)world, pos);
    }

    public static boolean isWoodSlabBlock(IBlockState blockState, Block block, IBlockAccess world, BlockPos pos) {
        int[] oreIds;
        if (block.isAir(blockState, world, pos)) {
            return false;
        }
        ItemStack stack = new ItemStack(block);
        if (stack.func_190926_b()) {
            return false;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreId != slabWoodId) continue;
            return true;
        }
        return false;
    }

    public static boolean isBreakableBlock(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return BlockUtil.isBreakableBlock(blockState, world, pos);
    }

    public static boolean isBreakableBlock(IBlockState blockState, World world, BlockPos pos) {
        return blockState.func_185887_b(world, pos) < 0.0f;
    }

    public static boolean isReplaceableBlock(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block.func_176200_f((IBlockAccess)world, pos) && !(block instanceof BlockStaticLiquid);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d startVec, Vec3d endVec, AxisAlignedBB bounds) {
        return BlockUtil.collisionRayTrace(pos, startVec, endVec, bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d startVec, Vec3d endVec, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        startVec = startVec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        endVec = endVec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vec3d vec32 = startVec.func_72429_b(endVec, minX);
        Vec3d vec33 = startVec.func_72429_b(endVec, maxX);
        Vec3d vec34 = startVec.func_72435_c(endVec, minY);
        Vec3d vec35 = startVec.func_72435_c(endVec, maxY);
        Vec3d vec36 = startVec.func_72434_d(endVec, minZ);
        Vec3d vec37 = startVec.func_72434_d(endVec, maxZ);
        if (!BlockUtil.isVecInsideYZBounds(vec32, minY, minZ, maxY, maxZ)) {
            vec32 = null;
        }
        if (!BlockUtil.isVecInsideYZBounds(vec33, minY, minZ, maxY, maxZ)) {
            vec33 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec34, minX, minZ, maxX, maxZ)) {
            vec34 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec35, minX, minZ, maxX, maxZ)) {
            vec35 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec36, minX, minY, maxX, maxY)) {
            vec36 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec37, minX, minY, maxX, maxY)) {
            vec37 = null;
        }
        Vec3d minHit = null;
        if (vec32 != null) {
            minHit = vec32;
        }
        if (vec33 != null && (minHit == null || startVec.func_72436_e(vec33) < startVec.func_72436_e(minHit))) {
            minHit = vec33;
        }
        if (vec34 != null && (minHit == null || startVec.func_72436_e(vec34) < startVec.func_72436_e(minHit))) {
            minHit = vec34;
        }
        if (vec35 != null && (minHit == null || startVec.func_72436_e(vec35) < startVec.func_72436_e(minHit))) {
            minHit = vec35;
        }
        if (vec36 != null && (minHit == null || startVec.func_72436_e(vec36) < startVec.func_72436_e(minHit))) {
            minHit = vec36;
        }
        if (vec37 != null && (minHit == null || startVec.func_72436_e(vec37) < startVec.func_72436_e(minHit))) {
            minHit = vec37;
        }
        if (minHit == null) {
            return null;
        }
        int sideHit = -1;
        if (minHit == vec32) {
            sideHit = 4;
        }
        if (minHit == vec33) {
            sideHit = 5;
        }
        if (minHit == vec34) {
            sideHit = 0;
        }
        if (minHit == vec35) {
            sideHit = 1;
        }
        if (minHit == vec36) {
            sideHit = 2;
        }
        if (minHit == vec37) {
            sideHit = 3;
        }
        return new RayTraceResult(minHit.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), EnumFacing.values()[sideHit], pos);
    }

    private static boolean isVecInsideYZBounds(@Nullable Vec3d vec, double minY, double minZ, double maxY, double maxZ) {
        return vec != null && vec.field_72448_b >= minY && vec.field_72448_b <= maxY && vec.field_72449_c >= minZ && vec.field_72449_c <= maxZ;
    }

    private static boolean isVecInsideXZBounds(@Nullable Vec3d vec, double minX, double minZ, double maxX, double maxZ) {
        return vec != null && vec.field_72450_a >= minX && vec.field_72450_a <= maxX && vec.field_72449_c >= minZ && vec.field_72449_c <= maxZ;
    }

    private static boolean isVecInsideXYBounds(@Nullable Vec3d vec, double minX, double minY, double maxX, double maxY) {
        return vec != null && vec.field_72450_a >= minX && vec.field_72450_a <= maxX && vec.field_72448_b >= minY && vec.field_72448_b <= maxY;
    }

    public static boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block.func_176200_f((IBlockAccess)world, pos) && !blockState.func_185904_a().func_76224_d();
    }

    public static boolean canPlaceTree(IBlockState blockState, World world, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        Block block = world.func_180495_p(downPos).func_177230_c();
        return (!block.func_176200_f((IBlockAccess)world, downPos) || !blockState.func_185904_a().func_76224_d()) && !block.isLeaves(blockState, (IBlockAccess)world, downPos) && !block.isWood((IBlockAccess)world, downPos);
    }

    public static BlockPos getNextReplaceableUpPos(World world, BlockPos pos) {
        BlockPos topPos = world.func_175645_m(pos);
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos(pos);
        IBlockState blockState = world.func_180495_p((BlockPos)newPos);
        while (!BlockUtil.canReplace(blockState, world, (BlockPos)newPos)) {
            newPos.func_189536_c(EnumFacing.UP);
            if (newPos.func_177956_o() > topPos.func_177956_o()) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)newPos);
        }
        return newPos.func_177977_b();
    }

    public static BlockPos getNextSolidDownPos(World world, BlockPos pos) {
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos(pos);
        IBlockState blockState = world.func_180495_p((BlockPos)newPos);
        while (BlockUtil.canReplace(blockState, world, (BlockPos)newPos)) {
            newPos.func_189536_c(EnumFacing.DOWN);
            if (newPos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)newPos);
        }
        return newPos.func_177984_a();
    }

    public static boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(blockAccess, pos);
        switch (side) {
            case DOWN: {
                if (!(axisalignedbb.field_72338_b > 0.0)) break;
                return true;
            }
            case UP: {
                if (!(axisalignedbb.field_72337_e < 1.0)) break;
                return true;
            }
            case NORTH: {
                if (!(axisalignedbb.field_72339_c > 0.0)) break;
                return true;
            }
            case SOUTH: {
                if (!(axisalignedbb.field_72334_f < 1.0)) break;
                return true;
            }
            case WEST: {
                if (!(axisalignedbb.field_72340_a > 0.0)) break;
                return true;
            }
            case EAST: {
                if (!(axisalignedbb.field_72336_d < 1.0)) break;
                return true;
            }
        }
        return !blockAccess.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    public static boolean setBlockWithPlaceSound(World world, BlockPos pos, IBlockState blockState) {
        if (world.func_175656_a(pos, blockState)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    public static boolean setBlockWithBreakSound(World world, BlockPos pos, IBlockState blockState, IBlockState oldState) {
        if (world.func_175656_a(pos, blockState)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, oldState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    public static boolean setBlockToAirWithSound(World world, BlockPos pos, IBlockState oldState) {
        if (world.func_175698_g(pos)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, oldState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends Comparable<T>> IProperty<T> getProperty(Block block, String propertyName, Class<T> valueClass) {
        for (IProperty property : block.func_176223_P().func_177227_a()) {
            if (!property.func_177701_a().equals(propertyName) || !property.func_177699_b().isAssignableFrom(valueClass)) continue;
            return property;
        }
        return null;
    }
}

