package forestry.arboriculture.blocks;

import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;

public class BlockDecorativeWoodPile extends BlockRotatedPillar implements IItemModelRegister {
	public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a("axis", EnumFacing.Axis.class);

	public BlockDecorativeWoodPile() {
		super(Material.field_151575_d);
		func_149672_a(SoundType.field_185848_a);
		func_149711_c(1.5f);
		func_149647_a(Tabs.tabArboriculture);
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149721_r(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149730_j(IBlockState state) {
		return false;
	}

	@Override
	public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return 12;
	}

	@Override
	public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return true;
	}

	@Override
	public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return 25;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < 3; i++) {
			manager.registerItemModel(item, i, "wood_pile");
		}
	}

	@Override
	public boolean rotateBlock(net.minecraft.world.World world, BlockPos pos, EnumFacing axis) {
		net.minecraft.block.state.IBlockState state = world.func_180495_p(pos);
		for (net.minecraft.block.properties.IProperty<?> prop : state.func_177228_b().keySet()) {
			if (prop.func_177701_a().equals("axis")) {
				world.func_175656_a(pos, state.func_177231_a(prop));
				return true;
			}
		}
		return false;
	}

	public IBlockState func_185499_a(IBlockState state, Rotation rot) {
		switch (rot) {
			case COUNTERCLOCKWISE_90:
			case CLOCKWISE_90:

				switch (state.func_177229_b(AXIS)) {
					case X:
						return state.func_177226_a(AXIS, EnumFacing.Axis.Z);
					case Z:
						return state.func_177226_a(AXIS, EnumFacing.Axis.X);
					default:
						return state;
				}

			default:
				return state;
		}
	}

	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(AXIS, EnumFacing.Axis.values()[meta]);
	}

	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(AXIS).ordinal();
	}

	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, AXIS);
	}

	protected ItemStack func_180643_i(IBlockState state) {
		return new ItemStack(Item.func_150898_a(this));
	}

	public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
		return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS, facing.func_176740_k());
	}

}
