/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.gui.events;

import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiElementEvent;
import forestry.api.gui.events.GuiEventOrigin;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class GuiEventHandler<E extends GuiElementEvent>
implements Consumer<E> {
    private final Consumer<E> handlerAction;
    private final Class<? super E> eventClass;
    private final GuiEventOrigin origin;
    @Nullable
    private final IGuiElement relative;

    public GuiEventHandler(Class<? super E> eventClass, Consumer<E> handlerAction) {
        this.origin = GuiEventOrigin.ANY;
        this.relative = null;
        this.eventClass = eventClass;
        this.handlerAction = handlerAction;
    }

    public GuiEventHandler(Class<? super E> eventClass, GuiEventOrigin origin, IGuiElement relative, Consumer<E> handlerAction) {
        this.origin = origin;
        this.relative = relative;
        this.eventClass = eventClass;
        this.handlerAction = handlerAction;
    }

    private boolean canHandle(GuiElementEvent event) {
        boolean instance = this.eventClass.isInstance(event);
        return instance && this.origin.isOrigin(event.getOrigin(), this.relative);
    }

    @Override
    public final void accept(E e) {
        if (this.canHandle((GuiElementEvent)e)) {
            this.handlerAction.accept(e);
        }
    }
}

