/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateType;

public enum ClimateSourceType {
    TEMPERATURE{

        @Override
        public boolean canChangeHumidity() {
            return false;
        }

        @Override
        public boolean canChangeTemperature() {
            return true;
        }
    }
    ,
    HUMIDITY{

        @Override
        public boolean canChangeHumidity() {
            return true;
        }

        @Override
        public boolean canChangeTemperature() {
            return false;
        }
    }
    ,
    BOTH{

        @Override
        public boolean canChangeHumidity() {
            return true;
        }

        @Override
        public boolean canChangeTemperature() {
            return true;
        }
    };


    public boolean affectClimateType(ClimateType type) {
        return this == BOTH || type == ClimateType.HUMIDITY && this == HUMIDITY || type == ClimateType.TEMPERATURE && this == TEMPERATURE;
    }

    public abstract boolean canChangeTemperature();

    public abstract boolean canChangeHumidity();
}

