/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.core.config.Config;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.elements.Window;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.ColourProperties;
import forestry.core.render.ForestryResource;
import forestry.core.tiles.IClimatised;
import forestry.energy.EnergyManager;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class GuiForestry<C extends Container>
extends GuiContainer
implements IGuiSizable {
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected final LedgerManager ledgerManager = new LedgerManager(this);
    protected final TextLayoutHelper textLayout;
    protected final Window window = new Window<GuiForestry>(this.field_146999_f, this.field_147000_g, this);

    protected GuiForestry(String texture, C container) {
        this(new ForestryResource(texture), container);
    }

    protected GuiForestry(ResourceLocation texture, C container) {
        super(container);
        this.textureFile = texture;
        this.container = container;
        this.textLayout = new TextLayoutHelper(this, ColourProperties.INSTANCE);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxLedgerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.ledgerManager.setMaxWidth(maxLedgerWidth);
        this.ledgerManager.clear();
        this.window.init(this.field_147003_i, this.field_147009_r);
        this.addLedgers();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.func_146280_a(mc, width, height);
    }

    public void func_73876_c() {
        this.window.updateClient();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected abstract void addLedgers();

    protected final void addErrorLedger(IErrorSource errorSource) {
        this.ledgerManager.add(errorSource);
    }

    protected final void addErrorLedger(IErrorLogicSource errorSource) {
        this.ledgerManager.add(errorSource.getErrorLogic());
    }

    protected final void addClimateLedger(IClimatised climatised) {
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, climatised));
    }

    protected final void addPowerLedger(EnergyManager energyManager) {
        if (Config.enableEnergyStat) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, energyManager));
        }
    }

    protected final void addHintLedger(String hintsKey) {
        if (Config.enableHints) {
            List hints = Config.hints.get((Object)hintsKey);
            this.addHintLedger(hints);
        }
    }

    protected final void addHintLedger(List<String> hints) {
        if (Config.enableHints && !hints.isEmpty()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hints));
        }
    }

    protected final void addOwnerLedger(IOwnedTile ownedTile) {
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, ownedTile));
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.ledgerManager.onGuiClosed();
    }

    public ColourProperties getFontColor() {
        return ColourProperties.INSTANCE;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        this.widgetManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        IGuiElement origin = this.window.getMousedOverElement() == null ? this.window : this.window.getMousedOverElement();
        this.window.postEvent(new GuiEvent.DownEvent(origin, mouseX, mouseY, mouseButton), GuiEventDestination.ALL);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (this.widgetManager.handleMouseRelease(mouseX, mouseY, mouseButton)) {
            return;
        }
        IGuiElement origin = this.window.getMousedOverElement() == null ? this.window : this.window.getMousedOverElement();
        this.window.postEvent(new GuiEvent.UpEvent(origin, mouseX, mouseY, mouseButton), GuiEventDestination.ALL);
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedElement() == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        IGuiElement origin = this.window.getFocusedElement() == null ? this.window : this.window.getFocusedElement();
        this.window.postEvent(new GuiEvent.KeyEvent(origin, typedChar, keyCode), GuiEventDestination.ALL);
    }

    @Nullable
    public FluidStack getFluidStackAtPosition(int mouseX, int mouseY) {
        for (Widget widget : this.widgetManager.getWidgets()) {
            TankWidget tankWidget;
            IFluidTank tank;
            if (!(widget instanceof TankWidget) || !widget.isMouseOver(mouseX - this.field_147003_i, mouseY - this.field_147009_r) || (tank = (tankWidget = (TankWidget)widget).getTank()) == null) continue;
            return tank.getFluid();
        }
        return null;
    }

    @Nullable
    protected Slot func_146975_c(int mouseX, int mouseY) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int mouseX, int mouseY) {
        return this.func_146978_c(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o().func_190926_b()) {
            GuiUtil.drawToolTips(this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_147002_h.field_75151_b, mouseX, mouseY);
            this.window.drawTooltip(mouseX, mouseY);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.drawBackground();
        this.widgetManager.updateWidgets(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawWidgets();
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.window.draw(mouseX, mouseY);
        this.bindTexture(this.textureFile);
    }

    protected void drawBackground() {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(texturePath);
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    @Override
    public int getSizeX() {
        return this.field_146999_f;
    }

    @Override
    public int getSizeY() {
        return this.field_147000_g;
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public Minecraft getMC() {
        return this.field_146297_k;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    public List<Rectangle> getExtraGuiAreas() {
        return this.ledgerManager.getLedgerAreas();
    }

    public TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }
}

