/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.blank;

import forestry.greenhouse.api.greenhouse.IBlankBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockHandler;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.GreenhouseBlock;
import forestry.greenhouse.multiblock.blocks.blank.BlankBlockHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlankBlock
extends GreenhouseBlock<IBlankBlock>
implements IBlankBlock {
    private final boolean[] faces = new boolean[6];
    private boolean hasWall;
    private boolean isValid;

    public BlankBlock(IGreenhouseProvider provider, BlockPos pos, EnumFacing rootFace, IBlankBlock root) {
        super(provider, pos, rootFace, root);
        if (rootFace != null) {
            this.faces[rootFace.ordinal()] = true;
        }
    }

    @Override
    public boolean isFaceTested(EnumFacing face) {
        return this.faces[face.ordinal()];
    }

    @Override
    public void setFaceTested(EnumFacing face, boolean isTested) {
        this.faces[face.ordinal()] = isTested;
    }

    @Override
    public boolean isNearWall() {
        return this.hasWall;
    }

    @Override
    public void setNearWall(boolean hasWall) {
        this.hasWall = hasWall;
    }

    @Override
    public void validate() {
        this.isValid = true;
    }

    @Override
    public void invalidate(boolean chunkUnloading) {
        this.isValid = false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public IGreenhouseBlockHandler getHandler() {
        return BlankBlockHandler.getInstance();
    }
}

