/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.models;

import forestry.api.core.CamouflageManager;
import forestry.api.core.ICamouflageItemHandler;
import forestry.api.core.IModelBaker;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockDefault;
import forestry.greenhouse.blocks.BlockGreenhouseSprite;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.IBlockCamouflaged;
import forestry.greenhouse.models.ModelOverlay;
import forestry.greenhouse.multiblock.GreenhouseController;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelCamouflaged<B extends Block>
extends ModelBlockDefault<B, Key> {
    public static final int DEFAULT_COLOR_INDEX = 100;
    public static final int OVERLAY_COLOR_INDEX = 101;
    public final ModelOverlay<B> overlayModel;

    public ModelCamouflaged(Class<B> blockClass) {
        super(blockClass);
        this.overlayModel = new ModelOverlay<B>(blockClass);
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.PLAIN, null, null, -1);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        return new Key(stack, stack.func_77952_i());
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        IExtendedBlockState stateExtended = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        return new Key(stateExtended, world, pos, state.func_177230_c().func_176201_c(state));
    }

    @Override
    protected void bakeBlock(B block, Key key, IModelBaker baker, boolean inventory) {
        IBlockAccess world = key.world;
        BlockPos pos = key.pos;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer != BlockRenderLayer.CUTOUT) {
            this.addCamouflageModel(block, baker, layer, world, pos);
        }
        if (layer == BlockRenderLayer.CUTOUT || layer == null) {
            IBakedModel model = key.state != null ? this.overlayModel.getModel((IBlockState)key.state) : this.overlayModel.getModel(key.itemStack, (World)Minecraft.func_71410_x().field_71441_e);
            baker.addBakedModelPost((IBlockState)key.state, model);
        }
    }

    private void addCamouflageModel(B block, IModelBaker baker, @Nullable BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            TextureAtlasSprite defaultSprite = ((IBlockCamouflaged)block).getDefaultSprite();
            baker.addBlockModel(pos, defaultSprite, 100);
            baker.setParticleSprite(defaultSprite);
        } else {
            ItemStack camouflageStack = ((IBlockCamouflaged)block).getCamouflageBlock(world, pos);
            if (camouflageStack.func_190926_b()) {
                camouflageStack = GreenhouseController.createDefaultCamouflageBlock();
            }
            Block camouflageBlock = Block.func_149634_a((Item)camouflageStack.func_77973_b());
            ICamouflageItemHandler itemHandler = CamouflageManager.camouflageAccess.getHandler(camouflageStack);
            if (itemHandler != null) {
                Pair<IBlockState, IBakedModel> modelPair = itemHandler.getModel(camouflageStack);
                IBlockState blockState = (IBlockState)modelPair.getLeft();
                if (layer != null && camouflageBlock.canRenderInLayer(blockState, layer)) {
                    IBakedModel bakedModel = (IBakedModel)modelPair.getRight();
                    baker.addBakedModel(blockState, bakedModel);
                    baker.setParticleSprite(bakedModel.func_177554_e());
                }
            }
        }
    }

    public static class Key {
        @Nullable
        public final IExtendedBlockState state;
        @Nullable
        public final IBlockAccess world;
        @Nullable
        public final BlockPos pos;
        public final ItemStack itemStack;
        public final int meta;

        public Key(@Nullable IExtendedBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int meta) {
            this.state = state;
            this.world = world;
            this.pos = pos;
            this.meta = meta;
            this.itemStack = ItemStack.field_190927_a;
        }

        public Key(ItemStack itemStack, int meta) {
            this.state = null;
            this.world = null;
            this.pos = null;
            this.meta = meta;
            this.itemStack = itemStack;
        }
    }
}

