/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.models;

import forestry.api.core.IModelBaker;
import forestry.core.models.ModelBlockCached;
import forestry.greenhouse.blocks.BlockGreenhouseSprite;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.IBlockCamouflaged;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelOverlay<B extends Block>
extends ModelBlockCached<B, Key> {
    public static final int OVERLAY_COLOR_INDEX = 101;

    public ModelOverlay(Class<B> blockClass) {
        super(blockClass);
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.PLAIN, null, null, -1);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        return new Key(null, stack.func_77952_i());
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return new Key(state, meta);
    }

    @Override
    protected void bakeBlock(B block, Key key, IModelBaker baker, boolean inventory) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == BlockRenderLayer.CUTOUT || layer == null) {
            for (int overlayLayer = 0; overlayLayer < ((IBlockCamouflaged)block).getLayers(); ++overlayLayer) {
                this.addOverlaySprite(block, baker, key.state, key.meta, overlayLayer);
            }
        }
    }

    @Override
    public IBakedModel getModel(IBlockState state) {
        return super.getModel(state);
    }

    @Override
    public IBakedModel getModel(ItemStack stack, World world) {
        return super.getModel(stack, world);
    }

    private void addOverlaySprite(B block, IModelBaker baker, IBlockState state, int meta, int layer) {
        if (((IBlockCamouflaged)block).hasOverlaySprite(meta, layer)) {
            TextureAtlasSprite[] sprite = new TextureAtlasSprite[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                sprite[facing.ordinal()] = ((IBlockCamouflaged)block).getOverlaySprite(facing, state, meta, layer);
            }
            baker.addBlockModel(null, sprite, 101 + layer);
        }
    }

    public static class Key {
        @Nullable
        public final IBlockState state;
        public final int meta;

        public Key(@Nullable IBlockState state, int meta) {
            this.state = state;
            this.meta = meta;
        }

        public int hashCode() {
            return Integer.hashCode(this.meta) * 31 + (this.state == null ? 0 : this.state.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key k = (Key)obj;
            return k.meta == this.meta && k.state == this.state;
        }
    }
}

