/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.google.common.base.Preconditions;
import forestry.api.circuits.ICircuit;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.PostManager;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ISaveEventHandler;
import forestry.core.ModuleCore;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.mail.EventHandlerMailAlert;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.blocks.BlockRegistryMail;
import forestry.mail.commands.CommandMail;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemRegistryMail;
import forestry.mail.network.PacketRegistryMail;
import forestry.mail.triggers.MailTriggers;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry", moduleID="mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.mail.description")
public class ModuleMail
extends BlankForestryModule {
    @Nullable
    private static ItemRegistryMail items;
    @Nullable
    private static BlockRegistryMail blocks;

    public static ItemRegistryMail getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static BlockRegistryMail getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void setupAPI() {
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryMail();
        blocks = new BlockRegistryMail();
    }

    @Override
    public void preInit() {
        ModuleCore.rootCommand.addChildCommand(new CommandMail());
        if (Config.mailAlertEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMailAlert());
        }
    }

    @Override
    public void registerTriggers() {
        MailTriggers.initialize();
    }

    @Override
    public void doInit() {
        BlockRegistryMail blocks = ModuleMail.getBlocks();
        blocks.mailbox.init();
        blocks.tradeStation.init();
        blocks.stampCollector.init();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryMail();
    }

    @Override
    public void registerRecipes() {
        ItemStack letterGlue;
        ItemStack stampGlue;
        ItemRegistryCore coreItems = ModuleCore.getItems();
        ItemRegistryMail items = ModuleMail.getItems();
        BlockRegistryMail blocks = ModuleMail.getBlocks();
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemRegistryApiculture beeItems = ModuleApiculture.getItems();
            stampGlue = beeItems.honeyDrop.getItemStack();
            letterGlue = beeItems.propolis.getWildcard();
        } else {
            stampGlue = new ItemStack(Items.field_151123_aH);
            letterGlue = new ItemStack(Items.field_151123_aH);
        }
        RecipeUtil.addShapelessRecipe("letter", items.letters.getItemStack(), Items.field_151121_aF, letterGlue);
        if (Config.craftingStampsEnabled) {
            for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
                if (Config.collectorStamps.contains(stampDefinition.getUid())) continue;
                ItemStack stamps = items.stamps.get(stampDefinition, 9);
                RecipeUtil.addRecipe("stamps_" + stampDefinition.getUid(), stamps, "XXX", "###", "ZZZ", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF, Character.valueOf('Z'), stampGlue);
                RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEED_OIL.getFluid(300), ItemStack.field_190927_a, stamps, "XXX", "###", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF);
            }
        }
        RecipeUtil.addRecipe("letter_recycling", new ItemStack(Items.field_151121_aF), "###", Character.valueOf('#'), "emptiedLetter");
        RecipeManagers.carpenterManager.addRecipe(10, new FluidStack(FluidRegistry.WATER, 250), ItemStack.field_190927_a, items.letters.getItemStack(), "###", "###", Character.valueOf('#'), coreItems.woodPulp);
        RecipeUtil.addShapelessRecipe("catalogue", items.catalogue.getItemStack(), items.stamps.getWildcard(), new ItemStack(Items.field_151122_aG));
        RecipeUtil.addRecipe("mailbox", new ItemStack((Block)blocks.mailbox), " # ", "#Y#", "XXX", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "chestWood", Character.valueOf('Y'), coreItems.sturdyCasing);
        RecipeUtil.addRecipe("trade_station", new ItemStack((Block)blocks.tradeStation), "Z#Z", "#Y#", "XWX", Character.valueOf('#'), coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Character.valueOf('X'), "chestWood", Character.valueOf('Y'), coreItems.sturdyCasing, Character.valueOf('Z'), coreItems.tubes.get(EnumElectronTube.IRON, 1), Character.valueOf('W'), ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }
}

