/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.storage;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.greenhouse.IClimateHousing;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.GreenhouseState;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.IBlankBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockHandler;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockStorage;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.multiblock.GreenhouseLimits;
import forestry.greenhouse.multiblock.GreenhouseLimitsBuilder;
import forestry.greenhouse.multiblock.blocks.blank.BlankBlockHandler;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.wall.WallBlockHandler;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import forestry.greenhouse.network.packets.PacketGreenhouseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GreenhouseProviderServer
extends GreenhouseProvider {
    private static final List<IGreenhouseBlockHandler> HANDLERS = new ArrayList<IGreenhouseBlockHandler>();
    private static final int TIME_BETWEEN_UPDATES = 75;
    private static final int UPDATE_DELAY = 150;
    private final Set<Long> unloadedChunks = new HashSet<Long>();
    private Position2D maxSize = Position2D.NULL_POSITION;
    private Position2D minSize = Position2D.NULL_POSITION;
    private boolean needReload;
    private long previousUpdateTick;

    public GreenhouseProviderServer(World world, IClimateContainer container) {
        super(world, container);
    }

    @Override
    public void create() {
        if (this.ready) {
            IClimateHousing region;
            BlockPos pos;
            GreenhouseState oldState = this.state;
            this.storage.removeProviderFromChunks();
            this.storage.clearBlocks(false);
            this.createBlocks();
            this.storage.addProviderToChunks();
            if (!this.world.field_72995_K && (pos = (region = this.container.getParent()).getCoordinates()) != null) {
                this.needReload = oldState != this.state;
                NetworkUtil.sendNetworkPacket(new PacketGreenhouseData(pos, this), pos, this.world);
            }
        }
    }

    @Override
    public void init(BlockPos centerPos, IGreenhouseLimits limits) {
        super.init(centerPos, limits);
    }

    @Override
    public void clear(boolean chunkUnloading) {
        super.clear(chunkUnloading);
        this.maxSize = Position2D.NULL_POSITION;
        this.minSize = Position2D.NULL_POSITION;
        this.unloadedChunks.clear();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        this.storage.writeData(data);
        data.writeByte(this.state.ordinal());
        data.writeBoolean(this.needReload);
        data.writeInt(this.size);
        data.func_179255_a(this.centerPos);
        if (this.limits != null && this.limits instanceof GreenhouseLimits) {
            data.writeBoolean(true);
            ((GreenhouseLimits)this.limits).writeData(data);
        } else {
            data.writeBoolean(false);
        }
        if (this.usedLimits != null && this.usedLimits instanceof GreenhouseLimits) {
            data.writeBoolean(true);
            ((GreenhouseLimits)this.usedLimits).writeData(data);
        } else {
            data.writeBoolean(false);
        }
        this.getErrorLogic().writeData(data);
    }

    @Override
    public void readData(PacketBufferForestry data) {
    }

    @Override
    public synchronized void recreate() {
        this.create();
    }

    @Override
    public void onUnloadChunk(long chunkPos) {
        this.unloadedChunks.add(chunkPos);
        this.getErrorLogic().setCondition(true, EnumErrorCode.NOT_LOADED);
        this.state = GreenhouseState.UNLOADED_CHUNK;
    }

    @Override
    public void onLoadChunk(long chunkPos) {
        this.unloadedChunks.remove(chunkPos);
        if (this.unloadedChunks.isEmpty() && this.hasUnloadedChunks()) {
            this.state = GreenhouseState.OPEN;
            this.create();
        }
    }

    @Override
    public IErrorState checkPosition(BlockPos position) {
        if (this.maxSize.getX() < position.func_177958_n() || this.maxSize.getZ() < position.func_177952_p() || this.minSize.getX() > position.func_177958_n() || this.minSize.getZ() > position.func_177952_p()) {
            return EnumErrorCode.TOO_LARGE;
        }
        if (!this.world.func_175667_e(position)) {
            this.unloadedChunks.add(ChunkPos.func_77272_a((int)(position.func_177958_n() >> 4), (int)(position.func_177952_p() >> 4)));
            return EnumErrorCode.NOT_LOADED;
        }
        return null;
    }

    @Override
    public Collection<IGreenhouseBlockHandler> getHandlers() {
        if (HANDLERS.isEmpty()) {
            HANDLERS.add(WallBlockHandler.getInstance());
            HANDLERS.add(BlankBlockHandler.getInstance());
        }
        return HANDLERS;
    }

    @Override
    public void onBlockChange() {
        long totalWorldTime = this.world.func_82737_E();
        if (totalWorldTime >= this.previousUpdateTick + 75L) {
            GreenhouseBlockManager blockManager = GreenhouseBlockManager.getInstance();
            blockManager.scheduleUpdate(this.world, this.container.getParent().getCoordinates(), this, 150);
            this.previousUpdateTick = totalWorldTime;
        }
    }

    @Override
    public void scheduledUpdate() {
        this.create();
    }

    private void createBlocks() {
        Stack<IGreenhouseBlock> blocksToCheck = new Stack<IGreenhouseBlock>();
        blocksToCheck.add(BlankBlockHandler.getInstance().createBlock((IGreenhouseBlockStorage)this.storage, (IBlankBlock)null, (EnumFacing)null, this.centerPos));
        this.checkState(this.checkBlocks(blocksToCheck));
    }

    private void checkState(GreenhouseState state) {
        this.state = state;
    }

    private GreenhouseState checkBlocks(Collection<IGreenhouseBlock> blocks) {
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.clearErrors();
        if (this.minSize == null || this.maxSize == null || this.minSize == Position2D.NULL_POSITION || this.maxSize == Position2D.NULL_POSITION) {
            Position2D maxCoordinates = this.limits.getMaximumCoordinates();
            this.maxSize = maxCoordinates.add(1, 1).add(this.centerPos.func_177958_n(), this.centerPos.func_177952_p());
            Position2D minCoordinates = this.limits.getMinimumCoordinates();
            this.minSize = minCoordinates.add(-1, -1).add(this.centerPos.func_177958_n(), this.centerPos.func_177952_p());
        }
        int greenhouseHeight = this.centerPos.func_177956_o();
        int greenhouseDepth = this.centerPos.func_177956_o();
        int height = 0;
        int depth = 0;
        int maximalHeight = ((IGreenhouseController)this.container.getParent()).getCenterCoordinates().func_177956_o() + this.limits.getHeight();
        GreenhouseLimitsBuilder builder = new GreenhouseLimitsBuilder();
        Stack<IGreenhouseBlock> blocksToCheck = new Stack<IGreenhouseBlock>();
        blocksToCheck.addAll(blocks);
        while (!blocksToCheck.isEmpty()) {
            IGreenhouseBlock blockToCheck = (IGreenhouseBlock)blocksToCheck.pop();
            if (blockToCheck == null) continue;
            BlockPos position = blockToCheck.getPos();
            IGreenhouseBlockHandler handler = blockToCheck.getHandler();
            builder.recalculate(position);
            LinkedList<IGreenhouseBlock> newBlocksToCheck = new LinkedList<IGreenhouseBlock>();
            IErrorState errorState = handler.checkNeighborBlocks(this.storage, blockToCheck, newBlocksToCheck);
            if (errorState != null) {
                errorLogic.setCondition(true, errorState);
                break;
            }
            blocksToCheck.addAll(newBlocksToCheck);
            if (!(blockToCheck instanceof IBlankBlock)) continue;
            int positionHeight = this.getHeight(position, maximalHeight);
            int positionDepth = this.getDepth(position);
            if (positionHeight == -1) {
                errorLogic.setCondition(true, EnumErrorCode.NOT_CLOSED);
                break;
            }
            if (positionHeight > greenhouseHeight) {
                greenhouseHeight = positionHeight;
            }
            height += positionHeight - this.centerPos.func_177956_o();
            if (positionDepth < greenhouseDepth) {
                greenhouseDepth = positionDepth;
            }
            depth += this.centerPos.func_177956_o() - positionDepth;
        }
        if (!this.unloadedChunks.isEmpty()) {
            errorLogic.setCondition(true, EnumErrorCode.NOT_LOADED);
            return GreenhouseState.UNLOADED_CHUNK;
        }
        if (errorLogic.hasErrors()) {
            if (errorLogic.getErrorStates().contains((Object)EnumErrorCode.TOO_LARGE)) {
                errorLogic.setCondition(false, EnumErrorCode.NOT_CLOSED);
            }
            return GreenhouseState.OPEN;
        }
        this.size = height + depth + this.storage.getBlockCount();
        this.usedLimits = builder.build(greenhouseHeight, greenhouseDepth);
        return GreenhouseState.CLOSED;
    }

    public int getHeight(BlockPos pos, int maximalHeight) {
        int worldHeight = this.world.func_72800_K();
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(pos);
        int height = -1;
        while (position.func_177956_o() <= worldHeight && position.func_177956_o() <= maximalHeight && height == -1) {
            IBlockState blockState = this.world.func_180495_p((BlockPos)position);
            AxisAlignedBB collisionBB = blockState.func_185890_d((IBlockAccess)this.world, pos);
            if (collisionBB == null || collisionBB.equals((Object)Block.field_185506_k) || blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)this.world, pos)) {
                position.func_189536_c(EnumFacing.UP);
                continue;
            }
            height = position.func_177977_b().func_177956_o();
        }
        return height;
    }

    public int getDepth(BlockPos pos) {
        int worldDepth = 0;
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(pos);
        int depth = -1;
        while (position.func_177956_o() > worldDepth && depth == -1) {
            IBlockState blockState = this.world.func_180495_p((BlockPos)position);
            AxisAlignedBB collisionBB = blockState.func_185890_d((IBlockAccess)this.world, pos);
            if (collisionBB == null || collisionBB.equals((Object)Block.field_185506_k) || blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)this.world, pos)) {
                position.func_189536_c(EnumFacing.DOWN);
                continue;
            }
            depth = position.func_177984_a().func_177956_o();
        }
        return depth;
    }
}

