/*******************************************************************************
 * The MIT License (MIT)
 * Copyright (c) 2013-2014 Slime Knights (mDiyo, fuj1n, Sunstrike, progwml6, pillbox, alexbegt)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Any alternate licenses are noted where appropriate.
 ******************************************************************************/
package forestry.book.data.structure;

import javax.annotation.Nullable;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class StructureBlockAccess implements IBlockAccess {

	private final StructureInfo data;
	private final IBlockState[][][] structure;

	public StructureBlockAccess(StructureInfo data) {
		this.data = data;
		this.structure = data.data;
	}

	@Nullable
	@Override
	public TileEntity func_175625_s(BlockPos pos) {
		return null;
	}

	@Override
	public int func_175626_b(BlockPos pos, int lightValue) {
		// full brightness always
		return 15 << 20 | 15 << 4;
	}

	@Override
	public IBlockState func_180495_p(BlockPos pos) {
		int x = pos.func_177958_n();
		int y = pos.func_177956_o();
		int z = pos.func_177952_p();

		if (y >= 0 && y < structure.length) {
			if (x >= 0 && x < structure[y].length) {
				if (z >= 0 && z < structure[y][x].length) {
					int index = y * (data.structureLength * data.structureWidth) + x * data.structureWidth + z;
					if (index <= data.getLimiter()) {
						return structure[y][x][z] != null ? structure[y][x][z] : Blocks.field_150350_a.func_176223_P();
					}
				}
			}
		}
		return Blocks.field_150350_a.func_176223_P();
	}

	@Override
	public boolean func_175623_d(BlockPos pos) {
		return func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
	}

	@Override
	public Biome func_180494_b(BlockPos pos) {
		return null;
	}

	@Override
	public int func_175627_a(BlockPos pos, EnumFacing direction) {
		return 0;
	}

	@Override
	public WorldType func_175624_G() {
		return null;
	}

	@Override
	public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
		return false;
	}
}
