/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.tiles.TileEntityDataFixable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

@Mod.EventBusSubscriber
public class MigrationHelper {
    private static Map<String, String> blockRemappings = new HashMap<String, String>();
    private static Map<String, String> itemRemappings = new HashMap<String, String>();
    private static Map<String, String> tileRemappings = new HashMap<String, String>();
    private static Set<String> ignoredMappings = new HashSet<String>();
    public static Pattern underscores;

    public static void registerFixable() {
        TileEntityDataFixable tileFixable = new TileEntityDataFixable();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs modFixs = fixer.init("forestry", tileFixable.func_188216_a());
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)tileFixable);
    }

    public static void addBlockName(String blockName) {
        MigrationHelper.add(blockName, blockRemappings);
    }

    public static void addItemName(String itemName) {
        MigrationHelper.add(itemName, itemRemappings);
    }

    public static void addTileName(String tileName) {
        MigrationHelper.add(tileName, tileRemappings);
    }

    private static void add(String name, Map<String, String> remappings) {
        String nameWithoutUnderscores = underscores.matcher(name).replaceAll("");
        if (!name.equals(nameWithoutUnderscores) && !remappings.containsKey(nameWithoutUnderscores)) {
            remappings.put(nameWithoutUnderscores, name);
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping missingMapping : event.getMappings()) {
            Block remappedBlock;
            ResourceLocation remappedResourceLocation;
            ResourceLocation resourceLocation = missingMapping.key;
            String resourcePath = resourceLocation.func_110623_a();
            if (ignoredMappings.contains(resourcePath)) {
                missingMapping.ignore();
                continue;
            }
            if (!blockRemappings.containsKey(resourcePath) || !ForgeRegistries.BLOCKS.containsKey(remappedResourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), blockRemappings.get(resourcePath))) || (remappedBlock = (Block)ForgeRegistries.BLOCKS.getValue(remappedResourceLocation)) == null || remappedBlock == Blocks.field_150350_a) continue;
            missingMapping.remap((IForgeRegistryEntry)remappedBlock);
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missingMapping : event.getMappings()) {
            Item remappedItem;
            ResourceLocation remappedResourceLocation;
            ResourceLocation resourceLocation = missingMapping.key;
            String resourcePath = resourceLocation.func_110623_a();
            if (ignoredMappings.contains(resourcePath)) {
                missingMapping.ignore();
                continue;
            }
            if (!itemRemappings.containsKey(resourcePath) || !ForgeRegistries.ITEMS.containsKey(remappedResourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), itemRemappings.get(resourcePath))) || (remappedItem = (Item)ForgeRegistries.ITEMS.getValue(remappedResourceLocation)) == null || remappedItem == Items.field_190931_a) continue;
            missingMapping.remap((IForgeRegistryEntry)remappedItem);
        }
    }

    @Nullable
    public static String getRemappedTileName(String resourcePath) {
        if (tileRemappings.containsKey(resourcePath)) {
            return "forestry:" + tileRemappings.get(resourcePath);
        }
        return null;
    }

    private MigrationHelper() {
    }

    public static void addTileRemappingName(String oldName, String remappedName) {
        tileRemappings.put("forestry." + WordUtils.uncapitalize((String)oldName), remappedName);
    }

    static {
        ignoredMappings.add("greenhouse.sprinkler");
        itemRemappings.put("greenhouse.plain", "greenhouse");
        blockRemappings.put("greenhouse.plain", "greenhouse");
        itemRemappings.put("greenhouse.gearbox", "greenhouse");
        blockRemappings.put("greenhouse.gearbox", "greenhouse");
        itemRemappings.put("greenhouse.control", "greenhouse");
        blockRemappings.put("greenhouse.control", "greenhouse");
        itemRemappings.put("greenhouse.fan", "climatiser.fan");
        blockRemappings.put("greenhouse.fan", "climatiser.fan");
        blockRemappings.put("greenhouse.heater", "climatiser.heater");
        itemRemappings.put("greenhouse.heater", "climatiser.heater");
        blockRemappings.put("greenhouse.dehumidifier", "climatiser.dehumidifier");
        itemRemappings.put("greenhouse.dehumidifier", "climatiser.dehumidifier");
        blockRemappings.put("greenhouse.humidifier", "climatiser.humidifier");
        itemRemappings.put("greenhouse.humidifier", "climatiser.humidifier");
        itemRemappings.put("greenhouse.dryer", "climatiser.dehumidifier");
        blockRemappings.put("greenhouse.dryer", "climatiser.dehumidifier");
        itemRemappings.put("pile_dirt", "loam");
        blockRemappings.put("pile_dirt", "loam");
        itemRemappings.put("pile_wood", "wood_pile");
        blockRemappings.put("pile_wood", "wood_pile");
        blockRemappings.put("pile_ash", "ash_block");
        MigrationHelper.addTileRemappingName("Alveary", "alveary_plain");
        MigrationHelper.addTileRemappingName("Swarm", "hive_wild");
        MigrationHelper.addTileRemappingName("AlvearySwarmer", "alveary_swarmer");
        MigrationHelper.addTileRemappingName("AlvearyHeater", "alveary_heater");
        MigrationHelper.addTileRemappingName("AlvearyFan", "alveary_fan");
        MigrationHelper.addTileRemappingName("AlvearyHygro", "alveary_hygro");
        MigrationHelper.addTileRemappingName("AlvearyStabiliser", "alveary_stabiliser");
        MigrationHelper.addTileRemappingName("AlvearySieve", "alveary_sieve");
        MigrationHelper.addTileRemappingName("Candle", "candle");
        MigrationHelper.addTileRemappingName("Sapling", "sapling");
        MigrationHelper.addTileRemappingName("Leaves", "leaves");
        MigrationHelper.addTileRemappingName("Pods", "pods");
        MigrationHelper.addTileRemappingName("Farm", "farm");
        MigrationHelper.addTileRemappingName("FarmGearbox", "farm_gearbox");
        MigrationHelper.addTileRemappingName("FarmHatch", "farm_hatch");
        MigrationHelper.addTileRemappingName("FarmValve", "farm_valve");
        MigrationHelper.addTileRemappingName("FarmControl", "farm_control");
        MigrationHelper.addTileRemappingName("GreenhousePlain", "greenhouse");
        MigrationHelper.addTileRemappingName("ClimateSourceHygroregulator", "greenhouse_hygro");
        MigrationHelper.addTileRemappingName("GreenhouseGearbox", "greenhouse_gearbox");
        MigrationHelper.addTileRemappingName("GreenhouseController", "greenhouse_controller");
        MigrationHelper.addTileRemappingName("ClimateSourceWindow", "greenhouse_window");
        MigrationHelper.addTileRemappingName("GreenhouseFan", "greenhouse_fan");
        MigrationHelper.addTileRemappingName("GreenhouseHeater", "greenhouse_heater");
        MigrationHelper.addTileRemappingName("GreenhouseDryer", "greenhouse_dehumidifier");
        MigrationHelper.addTileRemappingName("GreenhouseSprinkler", "greenhouse_humidifier");
        MigrationHelper.addTileRemappingName("GeneticFilter", "genetic_filter");
        underscores = Pattern.compile("_");
    }
}

