package forestry.core.network;

import javax.annotation.Nullable;
import java.io.IOException;
import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

import forestry.api.climate.ClimateStateType;
import forestry.api.climate.IClimateState;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateStates;
import forestry.greenhouse.api.greenhouse.Position2D;

import io.netty.buffer.ByteBuf;

public class PacketBufferForestry extends PacketBuffer {
	public PacketBufferForestry(ByteBuf wrapped) {
		super(wrapped);
	}

	public String readString() {
		return super.func_150789_c(1024);
	}

	public void writeItemStacks(NonNullList<ItemStack> itemStacks) {
		func_150787_b(itemStacks.size());
		for (ItemStack stack : itemStacks) {
			func_150788_a(stack);
		}
	}

	public NonNullList<ItemStack> readItemStacks() throws IOException {
		int stackCount = func_150792_a();
		NonNullList<ItemStack> itemStacks = NonNullList.func_191196_a();
		for (int i = 0; i < stackCount; i++) {
			itemStacks.add(func_150791_c());
		}
		return itemStacks;
	}

	public void writeInventory(IInventory inventory) {
		int size = inventory.func_70302_i_();
		func_150787_b(size);

		for (int i = 0; i < size; i++) {
			ItemStack stack = inventory.func_70301_a(i);
			func_150788_a(stack);
		}
	}

	public void readInventory(IInventory inventory) throws IOException {
		int size = func_150792_a();

		for (int i = 0; i < size; i++) {
			ItemStack stack = func_150791_c();
			inventory.func_70299_a(i, stack);
		}
	}

	public void writeFluidStack(@Nullable FluidStack fluidStack) {
		if (fluidStack == null) {
			func_150787_b(-1);
		} else {
			func_150787_b(fluidStack.amount);
			func_180714_a(fluidStack.getFluid().getName());
		}
	}

	@Nullable
	public FluidStack readFluidStack() {
		int amount = func_150792_a();
		if (amount > 0) {
			String fluidName = readString();
			Fluid fluid = FluidRegistry.getFluid(fluidName);
			if (fluid == null) {
				return null;
			}

			return new FluidStack(fluid, amount);
		}
		return null;
	}

	public void writePosition(Position2D position) {
		writeInt(position.getX());
		writeInt(position.getZ());
	}

	public Position2D readPosition() {
		return new Position2D(readInt(), readInt());
	}

	public void writeEntityById(Entity entity) {
		func_150787_b(entity.func_145782_y());
	}

	@Nullable
	public Entity readEntityById(World world) {
		int entityId = func_150792_a();
		return world.func_73045_a(entityId);
	}

	public <T extends Enum<T>> void writeEnum(T enumValue, T[] enumValues) {
		if (enumValues.length <= 256) {
			writeByte(enumValue.ordinal());
		} else {
			func_150787_b(enumValue.ordinal());
		}
	}

	public <T extends Enum<T>> T readEnum(T[] enumValues) {
		int ordinal;
		if (enumValues.length <= 256) {
			ordinal = readByte();
		} else {
			ordinal = func_150792_a();
		}
		return enumValues[ordinal];
	}
	
	public void writeStreamable(@Nullable Object object) {
		if (object != null && object instanceof IStreamable) {
			IStreamable streamable = (IStreamable) object;
			writeBoolean(true);
			streamable.writeData(this);
		} else {
			writeBoolean(false);
		}
	}

	public void writeStreamable(@Nullable IStreamable streamable) {
		if (streamable != null) {
			writeBoolean(true);
			streamable.writeData(this);
		} else {
			writeBoolean(false);
		}
	}

	@Nullable
	public <T extends IStreamable> T readStreamable(IStreamableFactory<T> factory) throws IOException {
		if (readBoolean()) {
			return factory.create(this);
		}
		return null;
	}

	public <T extends IStreamable> void writeStreamables(@Nullable List<T> streamables) {
		if (streamables == null) {
			func_150787_b(0);
		} else {
			func_150787_b(streamables.size());
			for (IStreamable streamable : streamables) {
				writeStreamable(streamable);
			}
		}
	}

	public <T extends IStreamable> void readStreamables(List<T> outputList, IStreamableFactory<T> factory) throws IOException {
		outputList.clear();
		int length = func_150792_a();
		if (length > 0) {
			for (int i = 0; i < length; i++) {
				T streamable = readStreamable(factory);
				outputList.add(streamable);
			}
		}
	}

	public interface IStreamableFactory<T extends IStreamable> {
		T create(PacketBufferForestry data) throws IOException;
	}

	public void writeClimateState(IClimateState climateState){
		if(climateState.isPresent()) {
			writeBoolean(true);
			writeByte(climateState.getType().ordinal());
			writeFloat(climateState.getTemperature());
			writeFloat(climateState.getHumidity());
		}else{
			writeBoolean(false);
		}
	}

	public IClimateState readClimateState(){
		if(readBoolean()){
			ClimateStateType type = ClimateStateType.values()[readByte()];
			return ClimateStates.of(readFloat(), readFloat(), type);
		}else{
			return AbsentClimateState.INSTANCE;
		}
	}
}
