/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory.wrappers;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

/**
 * Wrapper class used to bake the side variable into the object itself instead
 * of passing it around to all the inventory tools.
 *
 * @author CovertJaguar <http://www.railcraft.info>
 */
public class SidedInventoryMapper extends InvWrapperBase implements ISidedInventory {

	private final ISidedInventory inv;
	private final EnumFacing side;

	public SidedInventoryMapper(ISidedInventory inv, EnumFacing side) {
		this(inv, side, true);
	}

	public SidedInventoryMapper(ISidedInventory inv, EnumFacing side, boolean checkItems) {
		super(inv, checkItems);
		this.inv = inv;
		this.side = side;
	}

	@Override
	public boolean func_191420_l() {
		int[] slotsForFace = inv.func_180463_a(side);
		for (int slot : slotsForFace) {
			if (!inv.func_70301_a(slot).func_190926_b()) {
				return false;
			}
		}
		return true;
	}

	@Override
	public int[] func_180463_a(EnumFacing side) {
		return inv.func_180463_a(side);
	}

	@Override
	public boolean func_180462_a(int slot, ItemStack stack, EnumFacing s) {
		return !checkItems() || inv.func_180462_a(slot, stack, side);
	}

	@Override
	public boolean func_180461_b(int slot, ItemStack stack, EnumFacing s) {
		return !checkItems() || inv.func_180461_b(slot, stack, side);
	}

}
