/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.TileEscritoire;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class InventoryEscritoire
extends InventoryAdapterTile<TileEscritoire> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;

    public InventoryEscritoire(TileEscritoire escritoire) {
        super(escritoire, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 7 && slotIndex < 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5)) {
            ItemStack specimen = this.func_70301_a(0);
            if (specimen.func_190926_b()) {
                return false;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
            return individual != null && individual.getGenome().getPrimary().getResearchSuitability(itemStack) > 0.0f;
        }
        return slotIndex == 0 && (AlleleManager.alleleRegistry.isIndividual(itemStack) || GeneticsUtil.getGeneticEquivalent(itemStack) != null);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        if (slotIndex == 0) {
            return false;
        }
        if (this.func_70301_a(0).func_190926_b()) {
            return true;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 7, 5)) {
            return slotIndex >= 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, EnumFacing side) {
        return SlotUtil.isSlotInRange(slotIndex, 1, 6);
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        super.func_70299_a(slotIndex, itemstack);
        if (slotIndex == 0) {
            World world;
            ItemStack ersatz;
            if (!AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(0)) && !this.func_70301_a(0).func_190926_b() && AlleleManager.alleleRegistry.isIndividual(ersatz = GeneticsUtil.convertToGeneticEquivalent(this.func_70301_a(0)))) {
                super.func_70299_a(0, ersatz);
            }
            if ((world = ((TileEscritoire)this.tile).func_145831_w()) != null && !world.field_72995_K) {
                EscritoireGame game = ((TileEscritoire)this.tile).getGame();
                game.initialize(this.func_70301_a(0));
            }
        }
    }
}

