/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.multiblock;

import java.io.IOException;

import net.minecraft.nbt.NBTTagCompound;

import forestry.core.network.PacketBufferForestry;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.Position2D;

public class GreenhouseLimits implements IGreenhouseLimits {
	private final Position2D maximumCoordinates;
	private final Position2D minimumCoordinates;
	private final int height;
	private final int depth;

	public GreenhouseLimits(Position2D maximumCoordinates, Position2D minimumCoordinates, int height, int depth) {
		this.maximumCoordinates = maximumCoordinates;
		this.minimumCoordinates = minimumCoordinates;
		this.height = height;
		this.depth = depth;
	}

	public GreenhouseLimits(NBTTagCompound compound) {
		minimumCoordinates = new Position2D(compound.func_74775_l("minimumCoordinates"));
		maximumCoordinates = new Position2D(compound.func_74775_l("maximumCoordinates"));
		depth = compound.func_74762_e("depth");
		height = compound.func_74762_e("height");
	}

	public GreenhouseLimits(PacketBufferForestry data) {
		minimumCoordinates = data.readPosition();
		maximumCoordinates = data.readPosition();
		depth = data.readInt();
		height = data.readInt();
	}

	public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
		nbt.func_74782_a("minimumCoordinates", minimumCoordinates.writeToNBT(new NBTTagCompound()));
		nbt.func_74782_a("maximumCoordinates", maximumCoordinates.writeToNBT(new NBTTagCompound()));
		nbt.func_74768_a("depth", depth);
		nbt.func_74768_a("height", height);
		return nbt;
	}

	public void writeData(PacketBufferForestry data) {
		data.writePosition(minimumCoordinates);
		data.writePosition(maximumCoordinates);
		data.writeInt(depth);
		data.writeInt(height);
	}

	@Override
	public Position2D getMaximumCoordinates() {
		return maximumCoordinates;
	}

	@Override
	public Position2D getMinimumCoordinates() {
		return minimumCoordinates;
	}

	@Override
	public int getHeight() {
		return height;
	}

	@Override
	public int getDepth() {
		return depth;
	}
}
