/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.base.MoreObjects;
import forestry.api.climate.ClimateStateType;
import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStates;
import net.minecraft.nbt.NBTTagCompound;

class ClimateState
implements IClimateState,
IClimateInfo {
    public static final ClimateState MIN = new ClimateState(0.0f, 0.0f, ClimateStateType.DEFAULT);
    public static final ClimateState MAX = new ClimateState(2.0f, 2.0f, ClimateStateType.DEFAULT);
    public static final String TEMPERATURE_NBT_KEY = "TEMP";
    public static final String HUMIDITY_NBT_KEY = "HUMID";
    public static final String TYPE_NBT_KEY = "TYPE";
    public static final String ABSENT_NBT_KEY = "ABSENT";
    protected final ClimateStateType type;
    protected float temperature;
    protected float humidity;

    public ClimateState(IClimateState climateState, ClimateStateType type) {
        this(climateState.getTemperature(), climateState.getHumidity(), type);
    }

    public ClimateState(float temperature, float humidity, ClimateStateType type) {
        this.type = type;
        this.temperature = type.clamp(temperature);
        this.humidity = type.clamp(humidity);
    }

    public ClimateState(NBTTagCompound compound, ClimateStateType type) {
        this.type = type;
        this.readFromNBT(compound);
    }

    public ClimateState(NBTTagCompound compound) {
        this.type = ClimateStateType.values()[compound.func_74771_c(TYPE_NBT_KEY)];
        this.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74776_a(TEMPERATURE_NBT_KEY, this.temperature);
        compound.func_74776_a(HUMIDITY_NBT_KEY, this.humidity);
        compound.func_74774_a(TYPE_NBT_KEY, (byte)this.type.ordinal());
        compound.func_74757_a(ABSENT_NBT_KEY, !this.isPresent());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.temperature = this.type.clamp(compound.func_74760_g(TEMPERATURE_NBT_KEY));
        this.humidity = this.type.clamp(compound.func_74760_g(HUMIDITY_NBT_KEY));
    }

    @Override
    public IClimateState copy(ClimateStateType type) {
        return new ClimateState(this, type);
    }

    @Override
    public IClimateState copy() {
        return new ClimateState(this, this.type);
    }

    @Override
    public IClimateState addTemperature(float temperature) {
        return ClimateStates.of(this.temperature + temperature, this.humidity, this.type);
    }

    @Override
    public IClimateState addHumidity(float humidity) {
        return ClimateStates.of(this.temperature, this.humidity + humidity, this.type);
    }

    @Override
    public IClimateState add(IClimateState state) {
        return ClimateStates.of(this.temperature + state.getTemperature(), this.humidity + state.getHumidity(), this.type);
    }

    @Override
    public IClimateState scale(double factor) {
        return ClimateStates.of((float)((double)this.temperature * factor), (float)((double)this.humidity * factor), this.type);
    }

    @Override
    public IClimateState remove(IClimateState state) {
        return ClimateStates.of(this.temperature - state.getTemperature(), this.humidity - state.getHumidity(), this.type);
    }

    @Override
    public boolean isPresent() {
        return !Float.isNaN(this.temperature) && !Float.isNaN(this.humidity);
    }

    @Override
    public ClimateStateType getType() {
        return this.type;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IClimateState)) {
            return false;
        }
        IClimateState otherState = (IClimateState)obj;
        return otherState.getTemperature() == this.temperature && otherState.getHumidity() == this.humidity;
    }

    public int hashCode() {
        return Float.hashCode(this.temperature) * 31 + Float.hashCode(this.humidity);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temperature", this.temperature).add("humidity", this.humidity).toString();
    }
}

