/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.storage;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.core.network.IStreamable;
import forestry.greenhouse.api.climate.GreenhouseState;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.IGreenhouseProviderListener;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseBlockStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class GreenhouseProvider
implements IGreenhouseProvider,
IStreamable {
    protected final Set<IGreenhouseProviderListener> listeners = new HashSet<IGreenhouseProviderListener>();
    protected final GreenhouseBlockStorage storage;
    protected final World world;
    protected final IClimateContainer container;
    private final IErrorLogic errorLogic;
    protected BlockPos centerPos = BlockPos.field_177992_a;
    protected boolean ready;
    protected GreenhouseState state;
    @Nullable
    protected IGreenhouseLimits limits;
    @Nullable
    protected IGreenhouseLimits usedLimits;
    protected int size;

    public GreenhouseProvider(World world, IClimateContainer container) {
        this.world = world;
        this.container = container;
        this.state = GreenhouseState.UNREADY;
        this.storage = new GreenhouseBlockStorage(this, world);
        this.errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    }

    public abstract void create();

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public IClimateContainer getClimateContainer() {
        return this.container;
    }

    @Override
    public void addListener(IGreenhouseProviderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<IGreenhouseProviderListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void init(BlockPos centerPos, IGreenhouseLimits limits) {
        this.centerPos = centerPos;
        this.limits = limits;
        this.ready = true;
        this.state = GreenhouseState.UNLOADED;
    }

    @Override
    public void clear(boolean chunkUnloading) {
        this.storage.clearBlocks(chunkUnloading);
        this.centerPos = BlockPos.field_177992_a;
        this.ready = false;
    }

    @Override
    public boolean hasUnloadedChunks() {
        return this.state == GreenhouseState.UNLOADED_CHUNK;
    }

    @Override
    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    @Override
    public IGreenhouseLimits getLimits() {
        return this.limits;
    }

    @Override
    @Nullable
    public IGreenhouseLimits getUsedLimits() {
        return this.usedLimits;
    }

    @Override
    public GreenhouseState getState() {
        return this.state;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean isClosed() {
        return this.state == GreenhouseState.CLOSED;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public GreenhouseBlockStorage getStorage() {
        return this.storage;
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GreenhouseProvider)) {
            return false;
        }
        GreenhouseProvider provider = (GreenhouseProvider)obj;
        return provider.getClimateContainer().equals(this.container);
    }
}

