/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ItemStackUtil {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.func_190926_b() || rhs.func_190926_b()) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77952_i() != Short.MAX_VALUE && lhs.func_77952_i() != rhs.func_77952_i()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    @Nullable
    public static ResourceLocation getItemNameFromRegistry(Item item) {
        IForgeRegistry itemRegistry = ForgeRegistries.ITEMS;
        if (itemRegistry.containsValue((IForgeRegistryEntry)item)) {
            return itemRegistry.getKey((IForgeRegistryEntry)item);
        }
        return null;
    }

    @Nullable
    public static String getBlockNameFromRegistryAsString(Block block) {
        IForgeRegistry itemRegistry = ForgeRegistries.BLOCKS;
        if (itemRegistry.containsValue((IForgeRegistryEntry)block)) {
            return itemRegistry.getKey((IForgeRegistryEntry)block).toString();
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getBlockNameFromRegistry(Block block) {
        IForgeRegistry itemRegistry = ForgeRegistries.BLOCKS;
        if (itemRegistry.containsValue((IForgeRegistryEntry)block)) {
            return itemRegistry.getKey((IForgeRegistryEntry)block);
        }
        return null;
    }

    @Nullable
    public static String getItemNameFromRegistryAsString(Item item) {
        ResourceLocation itemNameFromRegistry = ItemStackUtil.getItemNameFromRegistry(item);
        if (itemNameFromRegistry == null) {
            return null;
        }
        return itemNameFromRegistry.toString();
    }

    @Nullable
    public static String getStringForItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        String itemStackString = ItemStackUtil.getItemNameFromRegistryAsString(item);
        if (itemStackString == null) {
            return null;
        }
        int meta = itemStack.func_77952_i();
        if (meta != Short.MAX_VALUE) {
            return itemStackString + ':' + meta;
        }
        return itemStackString;
    }

    @Nullable
    public static Item getItemFromRegistry(String itemName) {
        return ItemStackUtil.getItemFromRegistry(new ResourceLocation(itemName));
    }

    @Nullable
    public static Item getItemFromRegistry(ResourceLocation itemName) {
        IForgeRegistry itemRegistry = ForgeRegistries.ITEMS;
        if (!itemRegistry.containsKey(itemName)) {
            return null;
        }
        return (Item)itemRegistry.getValue(itemName);
    }

    @Nullable
    public static Block getBlockFromRegistry(String itemName) {
        return ItemStackUtil.getBlockFromRegistry(new ResourceLocation(itemName));
    }

    @Nullable
    public static Block getBlockFromRegistry(ResourceLocation itemName) {
        IForgeRegistry blockRegistry = ForgeRegistries.BLOCKS;
        if (!blockRegistry.containsKey(itemName)) {
            return null;
        }
        return (Block)blockRegistry.getValue(itemName);
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.func_190916_E() >= receptor.func_77976_d()) {
            return;
        }
        if (!receptor.func_77969_a(giver)) {
            return;
        }
        if (giver.func_190916_E() <= receptor.func_77976_d() - receptor.func_190916_E()) {
            receptor.func_190917_f(giver.func_190916_E());
            giver.func_190920_e(0);
            return;
        }
        ItemStack temp = giver.func_77979_a(receptor.func_77976_d() - receptor.func_190916_E());
        receptor.func_190917_f(temp.func_190916_E());
        temp.func_190920_e(0);
    }

    public static ItemStack createCopyWithCount(ItemStack stack, int count) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(count);
        return copy;
    }

    public static NonNullList<ItemStack> condenseStacks(NonNullList<ItemStack> stacks) {
        NonNullList condensed = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)cached, (ItemStack)stack)) continue;
                cached.func_190917_f(stack.func_190916_E());
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            condensed.add((Object)cached);
        }
        return condensed;
    }

    public static Pair<NonNullList<ItemStack>, NonNullList<String>> condenseStacks(NonNullList<ItemStack> stacks, NonNullList<String> dicts) {
        NonNullList condensed = NonNullList.func_191196_a();
        NonNullList condensedDicts = NonNullList.func_191196_a();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            if (stack.func_190926_b()) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)cached, (ItemStack)stack)) continue;
                cached.func_190917_f(stack.func_190916_E());
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            condensed.add((Object)cached);
            condensedDicts.add(dicts.get(i));
        }
        return Pair.of((Object)condensed, (Object)condensedDicts);
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!ItemStackUtil.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int containsSets(NonNullList<ItemStack> set, NonNullList<ItemStack> stock) {
        return ItemStackUtil.containsSets(set, stock, false, false);
    }

    public static int containsSets(NonNullList<ItemStack> set, NonNullList<ItemStack> stock, boolean oreDictionary, boolean craftingTools) {
        int totalSets = 0;
        NonNullList<ItemStack> condensedRequired = ItemStackUtil.condenseStacks(set);
        NonNullList<ItemStack> condensedOffered = ItemStackUtil.condenseStacks(stock);
        for (ItemStack req : condensedRequired) {
            int reqCount = 0;
            for (ItemStack offer : condensedOffered) {
                if (!ItemStackUtil.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.func_190916_E() / req.func_190916_E());
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static int containsSets(NonNullList<ItemStack> set, NonNullList<ItemStack> stock, NonNullList<String> oreDicts, boolean craftingTools) {
        int totalSets = 0;
        Pair<NonNullList<ItemStack>, NonNullList<String>> condensedRequired = ItemStackUtil.condenseStacks(set, oreDicts);
        NonNullList condensedRequiredDicts = (NonNullList)condensedRequired.getRight();
        NonNullList condensedRequiredStacks = (NonNullList)condensedRequired.getLeft();
        NonNullList<ItemStack> condensedOfferedStacks = ItemStackUtil.condenseStacks(stock);
        for (int y = 0; y < condensedRequiredStacks.size(); ++y) {
            ItemStack req = (ItemStack)condensedRequiredStacks.get(y);
            String offerDict = (String)condensedRequiredDicts.get(y);
            int reqCount = 0;
            for (ItemStack offer : condensedOfferedStacks) {
                if (!ItemStackUtil.isCraftingEquivalent(req, offer, offerDict, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.func_190916_E() / req.func_190916_E());
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static boolean equalSets(NonNullList<ItemStack> set1, NonNullList<ItemStack> set2) {
        if (set1 == set2) {
            return true;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        for (int i = 0; i < set1.size(); ++i) {
            if (ItemStackUtil.isIdenticalItem((ItemStack)set1.get(i), (ItemStack)set2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77952_i() != Short.MAX_VALUE && base.func_77952_i() != comparison.func_77952_i()) {
            return false;
        }
        if (base.func_77978_p() == null || base.func_77978_p().func_82582_d()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        if (ItemStackUtil.isCraftingEquivalent(base, comparison, craftingTools)) {
            return true;
        }
        if (oreDictionary) {
            int[] idsBase = OreDictionary.getOreIDs((ItemStack)base);
            Arrays.sort(idsBase);
            int[] idsComp = OreDictionary.getOreIDs((ItemStack)comparison);
            Arrays.sort(idsComp);
            int iBase = 0;
            int iComp = 0;
            while (iBase < idsBase.length && iComp < idsComp.length) {
                if (idsBase[iBase] < idsComp[iComp]) {
                    ++iBase;
                    continue;
                }
                if (idsBase[iBase] > idsComp[iComp]) {
                    ++iComp;
                    continue;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, @Nullable String oreDict, boolean craftingTools) {
        if (ItemStackUtil.isCraftingEquivalent(base, comparison, craftingTools)) {
            return true;
        }
        if (oreDict != null && !oreDict.isEmpty()) {
            int[] validIds = OreDictionary.getOreIDs((ItemStack)comparison);
            int validID = OreDictionary.getOreID((String)oreDict);
            for (int id : validIds) {
                if (id != validID) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean craftingTools) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (craftingTools && ItemStackUtil.isCraftingToolEquivalent(base, comparison)) {
            return true;
        }
        if (ItemStackUtil.isCraftingEquivalent(base, comparison)) {
            return true;
        }
        if (base.func_77978_p() != null && !base.func_77978_p().func_82582_d() && !ItemStack.func_77989_b((ItemStack)base, (ItemStack)comparison)) {
            return false;
        }
        return false;
    }

    public static boolean isCraftingToolEquivalent(ItemStack base, ItemStack comparison) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        Item baseItem = base.func_77973_b();
        if (baseItem != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77978_p() == null || base.func_77978_p().func_82582_d()) {
            return true;
        }
        if (base.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return base.func_77952_i() == comparison.func_77952_i();
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        ItemStackUtil.dropItemStackAsEntity(items, world, x, y, z, 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, BlockPos pos) {
        ItemStackUtil.dropItemStackAsEntity(items, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z, int delayForPickup) {
        if (items.func_190926_b() || world.field_72995_K) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.func_174867_a(delayForPickup);
        world.func_72838_d((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = max <= 0 ? 0 : rand.nextInt(max);
        ItemStack created = template.func_77946_l();
        if (size <= 0) {
            created.func_190920_e(1);
        } else if (size > created.func_77976_d()) {
            created.func_190920_e(created.func_77976_d());
        } else {
            created.func_190920_e(size);
        }
        return created;
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack);
    }

    public static boolean equals(IBlockState state, ItemStack stack) {
        return state.func_177230_c() == ItemStackUtil.getBlock(stack) && state.func_177230_c().func_176201_c(state) == stack.func_77952_i();
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack) && meta == stack.func_77952_i();
    }

    public static List<ItemStack> parseItemStackStrings(String[] itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    public static List<ItemStack> parseItemStackStrings(String itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    @Nullable
    public static ItemStack parseItemStackString(String itemStackString, int missingMetaValue) {
        Stack stack = Stack.parseStackString(itemStackString, missingMetaValue);
        if (stack == null) {
            return null;
        }
        return ItemStackUtil.getItemStack(stack);
    }

    private static List<ItemStack> getItemStacks(List<Stack> stacks) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(stacks.size());
        for (Stack stack : stacks) {
            Item item = stack.getItem();
            if (item == null) continue;
            int meta = stack.getMeta();
            ItemStack itemStack = new ItemStack(item, 1, meta);
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    @Nullable
    private static ItemStack getItemStack(Stack stack) {
        Item item = stack.getItem();
        if (item != null) {
            int meta = stack.getMeta();
            return new ItemStack(item, 1, meta);
        }
        return null;
    }

    public static boolean areItemStacksEqualIgnoreCount(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77952_i() != b.func_77952_i()) {
            return false;
        }
        if (a.func_77978_p() == null && b.func_77978_p() != null) {
            return false;
        }
        return (a.func_77978_p() == null || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible(b);
    }
}

