/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.pages;

import forestry.api.book.BookContent;
import forestry.api.book.IBookEntry;
import forestry.api.book.IBookPageFactory;
import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JsonPageFactory
implements IBookPageFactory {
    public static final String NAME = "json";
    public static final JsonPageFactory INSTANCE = new JsonPageFactory();

    private JsonPageFactory() {
    }

    @Override
    public Collection<IGuiElement> load(IBookEntry entry, int leftPageHeight, int rightPageHeight, int pageWidth) {
        ArrayList<IGuiElement> pages = new ArrayList<IGuiElement>();
        BookContent previous = null;
        IGuiElement previousElement = null;
        for (BookContent[] contentArray : entry.getContent()) {
            VerticalLayout page = new VerticalLayout(108);
            pages.add(page);
            for (BookContent content : contentArray) {
                if (content.addElements(page, GuiElementFactory.INSTANCE, previous, previousElement, 155 - (pages.size() % 2 == 1 ? 13 : 0))) {
                    previous = content;
                    previousElement = page.getLastElement();
                    page.layout();
                    continue;
                }
                previous = null;
                previousElement = null;
            }
            previous = null;
            previousElement = null;
        }
        return pages;
    }
}

