/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.ModuleCore;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.modules.ModuleHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ContainerAnalyzerProvider<T extends TileEntity>
extends ContainerTile<T>
implements IGuiSelectable {
    private final EntityPlayer player;
    @Nullable
    private final ItemInventoryAlyzer alyzerInventory;
    private final int analyzerIndex;

    public ContainerAnalyzerProvider(T tileForestry, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tileForestry, playerInventory, xInv, yInv);
        this.player = playerInventory.field_70458_d;
        ItemInventoryAlyzer alyzerInventory = null;
        int analyzerIndex = -1;
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModuleCore.getItems().portableAlyzer) continue;
            analyzerIndex = i;
            alyzerInventory = new ItemInventoryAlyzer(playerInventory.field_70458_d, stack);
            Slot slot = this.func_75147_a((IInventory)playerInventory, i);
            if (!(slot instanceof SlotLockable)) break;
            SlotLockable lockable = (SlotLockable)slot;
            lockable.lock();
            break;
        }
        this.analyzerIndex = analyzerIndex;
        this.alyzerInventory = alyzerInventory;
        if (alyzerInventory != null) {
            this.func_75146_a(new SlotAnalyzer(alyzerInventory, 0, -110, 20));
        }
    }

    @Nullable
    public Slot getAnalyzerSlot() {
        if (this.alyzerInventory == null) {
            return null;
        }
        return this.func_75147_a(this.alyzerInventory, 0);
    }

    private ItemStack analyzeSpecimen(int selectedSlot) {
        ISpeciesRoot speciesRoot;
        if (selectedSlot < 0 || this.alyzerInventory == null) {
            return ItemStack.field_190927_a;
        }
        Slot specimenSlot = this.getForestrySlot(selectedSlot);
        ItemStack specimen = specimenSlot.func_75211_c();
        if (specimen.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            specimenSlot.func_75215_d(convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) == null) {
            return specimen;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (individual != null && !individual.isAnalyzed()) {
            boolean requiresEnergy = ModuleHelper.isEnabled("apiculture");
            if (requiresEnergy && !ItemInventoryAlyzer.isAlyzingFuel(this.alyzerInventory.func_70301_a(0))) {
                return specimen;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                individual.writeToNBT(nbttagcompound);
                specimen = specimen.func_77946_l();
                specimen.func_77982_d(nbttagcompound);
                if (requiresEnergy) {
                    this.alyzerInventory.func_70298_a(0, 1);
                }
            }
            specimenSlot.func_75215_d(specimen);
        }
        return specimen;
    }

    @Override
    protected void addSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
        this.func_75146_a(new SlotLockable((IInventory)playerInventory, slot, x, y));
    }

    @Override
    protected void addHotbarSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
        this.func_75146_a(new SlotLockable((IInventory)playerInventory, slot, x, y));
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, int primary, int secondary) {
        this.analyzeSpecimen(secondary);
    }
}

