/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmProperties;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.Circuits;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.energy.ModuleEnergy;
import forestry.energy.blocks.BlockRegistryEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.farming.FarmRegistry;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRubber;
import forestry.farming.logic.farmables.FarmableBasicIC2Crop;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.plugins.BlockRegistryIC2;
import ic2.api.item.IC2Items;
import ic2.api.recipe.Recipes;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@ForestryModule(containerID="forestry_compat", moduleID="industrialcraft2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.ic2.description")
public class PluginIC2
extends BlankForestryModule {
    public static final String MOD_ID = "ic2";
    @Nullable
    private static ItemStack rubberSapling;
    @Nullable
    private static ItemStack rubber;
    @Nullable
    public static ItemStack rubberWood;
    @Nullable
    public static ItemStack resin;
    @Nullable
    public static ItemStack fertilizer;
    @Nullable
    public static BlockRegistryIC2 blocks;

    public static BlockRegistryIC2 getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryIC2();
    }

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(MOD_ID);
    }

    @Override
    public String getFailMessage() {
        return "IndustrialCraft2 not found";
    }

    @Override
    @Nonnull
    public Set<ResourceLocation> getDependencyUids() {
        HashSet<ResourceLocation> dependencyUids = new HashSet<ResourceLocation>();
        dependencyUids.add(new ResourceLocation("forestry", "core"));
        dependencyUids.add(new ResourceLocation("forestry", "farming"));
        dependencyUids.add(new ResourceLocation("forestry", "factory"));
        return dependencyUids;
    }

    @Override
    @Optional.Method(modid="ic2")
    public void preInit() {
        rubberWood = IC2Items.getItem((String)"rubber_wood");
        resin = IC2Items.getItem((String)"misc_resource", (String)"resin");
        rubberSapling = IC2Items.getItem((String)"sapling");
        rubber = IC2Items.getItem((String)"crafting", (String)"rubber");
        fertilizer = IC2Items.getItem((String)"crop_res", (String)"fertilizer");
        IFarmProperties rubberFarm = FarmRegistry.getInstance().registerLogic("farmRubber", FarmLogicRubber::new, new String[0]);
        Circuits.farmRubberManual = new CircuitFarmLogic("manualRubber", rubberFarm, true);
        CircuitLayout layoutEngineTin = new CircuitLayout("engine.tin", CircuitSocketType.ELECTRIC_ENGINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutEngineTin);
        if (fertilizer != null) {
            FarmRegistry.getInstance().registerFertilizer(fertilizer, 250);
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void doInit() {
        if (Recipes.recyclerBlacklist != null) {
            ItemRegistryApiculture beeItems = ModuleApiculture.getItems();
            if (beeItems != null) {
                Recipes.recyclerBlacklist.add(Recipes.inputFactory.forStack(new ItemStack((Item)beeItems.beeQueenGE)));
                Recipes.recyclerBlacklist.add(Recipes.inputFactory.forStack(new ItemStack((Item)beeItems.beePrincessGE)));
            }
        } else {
            Log.error("IC2 Recipes.recyclerBlacklist not found.", new Object[0]);
        }
        Circuits.energyElectricChoke1 = new CircuitElectricChoke("electric.choke.1");
        Circuits.energyElectricEfficiency1 = new CircuitElectricEfficiency("electric.efficiency.1");
        Circuits.energyElectricBoost1 = new CircuitElectricBoost("electric.boost.1", 4, 10);
        Circuits.energyElectricBoost2 = new CircuitElectricBoost("electric.boost.2", 7, 20);
        PluginIC2.blocks.electricalEngine.init();
        PluginIC2.blocks.generator.init();
    }

    @Override
    public void postInit() {
        ItemStack rubberLeaves;
        if (BackpackManager.backpackInterface == null) {
            return;
        }
        if (resin != null) {
            BackpackManager.backpackInterface.addItemToForestryBackpack("forestry.forester", resin);
        }
        if (rubber != null) {
            BackpackManager.backpackInterface.addItemToForestryBackpack("forestry.forester", rubber);
        }
        if (rubberSapling != null) {
            BackpackManager.backpackInterface.addItemToForestryBackpack("forestry.forester", rubberSapling);
        }
        if ((rubberLeaves = IC2Items.getItem((String)"leaves")) != null) {
            BackpackManager.backpackInterface.addItemToForestryBackpack("forestry.forester", rubberLeaves);
        }
    }

    @Override
    public void registerCrates() {
        ItemStack brass;
        ItemStack silver;
        ItemStack uuMatter;
        ItemStack scrap;
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (crateRegistry == null) {
            return;
        }
        if (resin != null) {
            crateRegistry.registerCrate(resin);
        }
        if (rubber != null) {
            crateRegistry.registerCrate(rubber);
        }
        if ((scrap = IC2Items.getItem((String)"crafting", (String)"scrap")) != null) {
            crateRegistry.registerCrate(scrap);
        }
        if ((uuMatter = IC2Items.getItem((String)"misc_resource", (String)"matter")) != null) {
            crateRegistry.registerCrate(uuMatter);
        }
        if ((silver = IC2Items.getItem((String)"ingot", (String)"silver")) != null) {
            crateRegistry.registerCrate(silver);
        }
        if ((brass = IC2Items.getItem((String)"ingot", (String)"bronze")) != null) {
            crateRegistry.registerCrate(brass);
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void registerRecipes() {
        BlockRegistryEnergy energyBlocks;
        int bogEarthOutputCan;
        ItemStack waterCell;
        Fluid biogas;
        String saplingName;
        ItemRegistryApiculture beeItems;
        ItemStack bioChaff;
        ItemStack plantBall;
        ItemRegistryCore coreItems = ModuleCore.items;
        if (rubber != null) {
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), coreItems.tubes.get(EnumElectronTube.RUBBER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "itemRubber"});
        }
        if ((plantBall = IC2Items.getItem((String)"crafting", (String)"plant_ball")) != null) {
            RecipeUtil.addFermenterRecipes(plantBall, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if ((bioChaff = IC2Items.getItem((String)"crafting", (String)"bio_chaff")) != null) {
            RecipeUtil.addFermenterRecipes(bioChaff, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if ((beeItems = ModuleApiculture.getItems()) != null) {
            if (resin != null) {
                RecipeManagers.centrifugeManager.addRecipe(20, beeItems.propolis.get(EnumPropolis.NORMAL, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)resin, (Object)Float.valueOf(1.0f)));
            } else {
                Log.info("Missing IC2 resin, skipping centrifuge recipe for propolis to resin.", new Object[0]);
            }
        }
        if (rubberSapling != null) {
            RecipeUtil.addFermenterRecipes(rubberSapling, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        } else {
            Log.info("Missing IC2 rubber sapling, skipping fermenter recipe for converting rubber sapling to biomass.", new Object[0]);
        }
        if (rubberSapling != null && resin != null && (saplingName = ItemStackUtil.getBlockNameFromRegistryAsString(ItemStackUtil.getBlock(rubberSapling))) != null) {
            String resinName = ItemStackUtil.getItemNameFromRegistryAsString(resin.func_77973_b());
            String imc = String.format("farmArboreal@%s.%s.%s.%s", saplingName, rubberSapling.func_77952_i(), resinName, resin.func_77952_i());
            Log.trace("Sending IMC '%s'.", imc);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-farmable-sapling", (String)imc);
        }
        if (ModuleHelper.isEnabled("energy") && (biogas = FluidRegistry.getFluid((String)"ic2biogas")) != null) {
            int burnDuration = Math.round(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas"));
            EngineBronzeFuel bronzeFuel = new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, burnDuration, 1);
            FuelManager.bronzeEngineFuel.put(biogas, bronzeFuel);
        }
        if ((waterCell = IC2Items.getItem((String)"fluid_cell", (String)"water")) != null && (bogEarthOutputCan = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.can")) > 0) {
            ItemStack bogEarthCan = ModuleCore.getBlocks().bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputCan);
            RecipeUtil.addRecipe("ic2_bog_earth_can", bogEarthCan, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waterCell, Character.valueOf('Y'), "sand");
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.engine.tin");
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.COPPER, 1), Circuits.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.TIN, 1), Circuits.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Circuits.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.IRON, 1), Circuits.energyElectricEfficiency1);
        if (ModuleHelper.isEnabled("farming")) {
            if (resin != null && rubberWood != null) {
                ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
                ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.RUBBER, 1), Circuits.farmRubberManual);
            }
            FarmRegistry.getInstance().registerFarmables("farmOrchard", new FarmableBasicIC2Crop());
        }
        if ((energyBlocks = ModuleEnergy.blocks) != null) {
            RecipeUtil.addRecipe("ic2_generator", PluginIC2.blocks.generator, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), coreItems.sturdyCasing);
            RecipeUtil.addRecipe("ic2_eletrical_engine", PluginIC2.blocks.electricalEngine, "###", " X ", "YVY", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearTin", Character.valueOf('V'), Blocks.field_150331_J);
        }
    }
}

