/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.storage;

import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseChunk;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public class GreenhouseChunk
implements IGreenhouseChunk {
    public final Set<IGreenhouseProvider> providers = new HashSet<IGreenhouseProvider>();
    public final Set<IGreenhouseProvider> dirtyProviders = new HashSet<IGreenhouseProvider>();

    public Set<IGreenhouseProvider> getProviders() {
        return this.providers;
    }

    @Override
    public synchronized void markProviderDirty(BlockPos pos) {
        IGreenhouseBlock block = this.get(pos);
        if (block != null) {
            this.dirtyProviders.add(block.getProvider());
        }
    }

    @Override
    public synchronized Collection<IGreenhouseProvider> getDirtyProviders() {
        return this.dirtyProviders;
    }

    @Override
    @Nullable
    public IGreenhouseBlock get(BlockPos pos) {
        IGreenhouseProvider provider;
        IGreenhouseBlock block = null;
        Iterator<IGreenhouseProvider> iterator = this.providers.iterator();
        while (iterator.hasNext() && (block = (provider = iterator.next()).getStorage().getBlock(pos)) == null) {
        }
        return block;
    }

    @Override
    public void add(IGreenhouseProvider manager) {
        this.providers.add(manager);
    }

    @Override
    public void remove(IGreenhouseProvider manager) {
        this.providers.remove(manager);
    }

    public synchronized void markProviderDirty(IGreenhouseProvider dirtyProvider) {
        if (dirtyProvider != null) {
            this.dirtyProviders.add(dirtyProvider);
        }
    }
}

