/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.genetics.BeeDatabaseTab;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.config.Config;
import forestry.core.genetics.analyzer.DatabasePlugin;
import forestry.core.genetics.analyzer.MutationsTab;
import forestry.core.genetics.analyzer.ProductsTab;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BeePlugin
extends DatabasePlugin<IBee> {
    public static final BeePlugin INSTANCE = new BeePlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private BeePlugin() {
        super(new BeeDatabaseTab(true), new BeeDatabaseTab(false), new ProductsTab(() -> ModuleApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1)), new MutationsTab(() -> ModuleApiculture.getItems().frameImpregnated.getItemStack()));
        NonNullList beeList = NonNullList.func_191196_a();
        ModuleApiculture.getItems().beeDroneGE.addCreativeItems((NonNullList<ItemStack>)beeList, false);
        for (ItemStack beeStack : beeList) {
            IAlleleBeeSpecies species = BeeGenome.getSpecies(beeStack);
            this.iconStacks.put(species.getUID(), beeStack);
        }
    }

    @Override
    public Map<String, ItemStack> getIndividualStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"beealyzer");
    }
}

