/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.blocks;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Plane;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Log;
import forestry.greenhouse.ModuleGreenhouse;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import forestry.greenhouse.tiles.TileGreenhouseWindow.WindowMode;

public class BlockGreenhouseWindow extends Block implements IBlockRotatable, ITileEntityProvider, IItemModelRegister {
	public static final PropertyDirection FACING = PropertyDirection.func_177712_a("facing", Plane.HORIZONTAL);

	private boolean roofWindow;

	public BlockGreenhouseWindow(boolean roofWindow) {
		super(Material.field_151576_e);
		IBlockState defaultState = this.field_176227_L.func_177621_b();
		func_180632_j(defaultState.func_177226_a(FACING, EnumFacing.NORTH));

		func_149711_c(1.0f);
		setHarvestLevel("pickaxe", 0);
		func_149647_a(ModuleGreenhouse.getGreenhouseTab());
		func_149672_a(SoundType.field_185853_f);
		this.roofWindow = roofWindow;
	}

	public ItemStack getItem(String glass) {
		ItemStack stack = new ItemStack(this);
		NBTTagCompound tagCompound = new NBTTagCompound();
		tagCompound.func_74778_a("Glass", glass);
		stack.func_77982_d(tagCompound);
		return stack;
	}

	protected int getPlaySound(boolean open) {
		if (open) {
			return 1007;
		} else {
			return 1013;
		}
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(FACING, EnumFacing.field_82609_l[meta + 2]);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(FACING).ordinal() - 2;
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
		TileEntity tile = TileUtil.getTile(worldIn, pos, TileEntity.class);
		if (tile instanceof IActivatable) {
			state = state.func_177226_a(State.PROPERTY, ((IActivatable) tile).isActive() ? State.ON : State.OFF);
		}
		return super.func_176221_a(state, worldIn, pos);
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_185499_a(IBlockState state, Rotation rot) {
		EnumFacing facing = state.func_177229_b(FACING);
		return state.func_177226_a(FACING, rot.func_185831_a(facing));
	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean func_149686_d(IBlockState state) {
		return false;
	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	@Deprecated
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
		try {
			TileUtil.actOnTile(worldIn, pos, TileGreenhouseWindow.class, TileGreenhouseWindow::onNeighborBlockChange);
		} catch (StackOverflowError error) {
			Log.error("Stack Overflow Error in BlockMachine.onNeighborBlockChange()", error);
			throw error;
		}
	}

	/* MODELS */
	@Override
	@SideOnly(Side.CLIENT)
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.TRANSLUCENT;
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (playerIn.func_70093_af()) {
			return false;
		}

		TileGreenhouseWindow window = TileUtil.getTile(worldIn, pos, TileGreenhouseWindow.class);
		if (window == null) {
			return false;
		}

		if (playerIn.func_184614_ca().func_190926_b()) {
			if (window.getMode() != WindowMode.CONTROL) {
				if (!worldIn.field_72995_K) {
					if (window.isBlocked() == WindowMode.OPEN) {
						if (window.getMode() == WindowMode.OPEN) {
							window.setMode(WindowMode.PLAYER);
						} else {
							window.setMode(WindowMode.OPEN);
						}
					}
				}
				worldIn.func_180498_a(playerIn, getPlaySound(!window.isActive()), pos, 0);
				return true;
			}
		}

		return false;
	}

	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
		super.func_180633_a(world, pos, state, placer, stack);
		TileUtil.actOnTile(world, pos, TileGreenhouseWindow.class, window -> {
			if (!window.func_145831_w().field_72995_K) {
				window.setMode(window.isBlocked());
			}
			NBTTagCompound itemTag = stack.func_77978_p();
			if (itemTag != null) {
				window.setGlass(itemTag.func_74779_i("Glass"));
			}
		});
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (String glass : GreenhouseManager.helper.getWindowGlasses()) {
			list.add(getItem(glass));
		}
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new ExtendedBlockState(this, new IProperty[]{State.PROPERTY, FACING}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
	}

	@Override
	public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
		func_176226_b(worldIn, pos, state, 0);
		super.func_180663_b(worldIn, pos, state);
	}

	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		List<ItemStack> ret = new java.util.ArrayList<>();
		TileGreenhouseWindow window = TileUtil.getTile(world, pos, TileGreenhouseWindow.class);
		if (window != null) {
			ret.add(getItem(window.getGlass()));
		}
		return ret;
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		List<ItemStack> drops = getDrops(world, pos, world.func_180495_p(pos), 0);
		if (drops.isEmpty()) {
			return super.getPickBlock(state, target, world, pos, player);
		}
		return drops.get(0);
	}

	@Override
	public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
		return ((IExtendedBlockState) super.getExtendedState(state, world, pos)).withProperty(UnlistedBlockPos.POS, pos)
				.withProperty(UnlistedBlockAccess.BLOCKACCESS, world);
	}

	@Override
	public void rotateAfterPlacement(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
		IBlockState state = world.func_180495_p(pos);
		world.func_175656_a(pos, state.func_177226_a(FACING, player.func_174811_aO().func_176734_d()));
	}

	@Override
	public TileEntity func_149915_a(World world, int meta) {
		return new TileGreenhouseWindow();
	}

	public boolean isRoofWindow() {
		return roofWindow;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		if (roofWindow) {
			ModelLoader.setCustomModelResourceLocation(item, 0, new ModelResourceLocation("forestry:greenhouse_window_up", "inventory"));
		} else {
			ModelLoader.setCustomModelResourceLocation(item, 0, new ModelResourceLocation("forestry:greenhouse_window", "inventory"));
		}
	}

}
