/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.items;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import forestry.core.ModuleCore;
import forestry.core.utils.ItemStackUtil;

public class ItemForestryTool extends ItemForestry {
	private final ItemStack remnants;
	private float efficiencyOnProperMaterial;

	public ItemForestryTool(ItemStack remnants) {
		this.field_77777_bU = 1;
		efficiencyOnProperMaterial = 6F;
		func_77656_e(200);
		this.remnants = remnants;
		if (!remnants.func_190926_b()) {
			MinecraftForge.EVENT_BUS.register(this);
		}
	}

	public void setEfficiencyOnProperMaterial(float efficiencyOnProperMaterial) {
		this.efficiencyOnProperMaterial = efficiencyOnProperMaterial;
	}

	@Override
	public boolean func_150897_b(IBlockState block) {
		if (this == ModuleCore.getItems().bronzePickaxe) {
			Material material = block.func_185904_a();
			return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
		}
		return super.func_150897_b(block);
	}

	@Override
	public float func_150893_a(ItemStack itemstack, IBlockState state) {
		for (String type : getToolClasses(itemstack)) {
			if (state.func_177230_c().isToolEffective(type, state)) {
				return efficiencyOnProperMaterial;
			}
		}
		if (this == ModuleCore.getItems().bronzePickaxe) {
			Material material = state.func_185904_a();
			return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(itemstack, state) : this.efficiencyOnProperMaterial;
		}
		return super.func_150893_a(itemstack, state);
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (this == ModuleCore.getItems().bronzeShovel) {
			ItemStack heldItem = player.func_184586_b(hand);
			if (!player.func_175151_a(pos.func_177972_a(facing), facing, heldItem)) {
				return EnumActionResult.FAIL;
			} else {
				IBlockState iblockstate = worldIn.func_180495_p(pos);
				Block block = iblockstate.func_177230_c();

				if (facing != EnumFacing.DOWN && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && block == Blocks.field_150349_c) {
					IBlockState iblockstate1 = Blocks.field_185774_da.func_176223_P();
					worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0F, 1.0F);

					if (!worldIn.field_72995_K) {
						worldIn.func_180501_a(pos, iblockstate1, 11);
						heldItem.func_77972_a(1, player);
					}

					return EnumActionResult.SUCCESS;
				} else {
					return EnumActionResult.PASS;
				}
			}
		}
		return EnumActionResult.PASS;
	}

	@SubscribeEvent
	public void onDestroyCurrentItem(PlayerDestroyItemEvent event) {
		if (event.getOriginal().func_190926_b() || event.getOriginal().func_77973_b() != this) {
			return;
		}

		EntityPlayer player = event.getEntityPlayer();
		World world = player.field_70170_p;

		if (!world.field_72995_K && !remnants.func_190926_b()) {
			ItemStackUtil.dropItemStackAsEntity(remnants.func_77946_l(), world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
		}
	}

	@Override
	public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
		if (state.func_185887_b(worldIn, pos) != 0) {
			stack.func_77972_a(1, entityLiving);
		}
		return true;
	}

	@Override
	public boolean func_77662_d() {
		return true;
	}
}
