package forestry.core.gui.buttons;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

import forestry.core.gui.Drawable;

public class GuiToggleButton extends GuiButton {
	/* attributes - Final */
	private final Drawable[] textures = new Drawable[3];

	public GuiToggleButton(int buttonId, int x, int y, int widthIn, int heightIn, Drawable drawable) {
		super(buttonId, x, y, widthIn, heightIn, "");
		for(int i = 0;i < 3;i++){
			textures[i] = new Drawable(drawable.textureLocation, drawable.u, drawable.v + drawable.vHeight * i, drawable.uWidth, drawable.vHeight);
		}
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
		this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
		int hoverState = this.func_146114_a(this.field_146123_n);
		Drawable drawable = textures[hoverState];
		drawable.draw(field_146128_h, field_146129_i);
	}
}
