package forestry.book.gui.buttons;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.book.IBookEntry;
import forestry.core.gui.GuiUtil;

@SideOnly(Side.CLIENT)
public class GuiButtonEntry extends GuiButton {
	public final IBookEntry entry;

	public GuiButtonEntry(int buttonId, int x, int y, IBookEntry entry) {
		super(buttonId, x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(entry.getTitle()) + 9, 11, entry.getTitle());
		this.entry = entry;
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
		if (this.field_146125_m) {
			FontRenderer fontRenderer = mc.field_71466_p;
			GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
			this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;

			String text = field_146126_j;
			if (field_146123_n) {
				text = TextFormatting.GOLD + text;
			} else {
				text = TextFormatting.DARK_GRAY + text;
			}

			boolean unicode = fontRenderer.func_82883_a();
			fontRenderer.func_78264_a(true);
			fontRenderer.func_78276_b(text, this.field_146128_h + 9, this.field_146129_i, 0);
			fontRenderer.func_78264_a(unicode);

			ItemStack stack = entry.getStack();
			if (!stack.func_190926_b()) {
				GlStateManager.func_179094_E();
				GlStateManager.func_179109_b(field_146128_h, field_146129_i, field_73735_i);
				RenderHelper.func_74520_c();
				GlStateManager.func_179091_B();
				GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
				GuiUtil.drawItemStack(fontRenderer, stack, 0, 0);
				RenderHelper.func_74518_a();
				GlStateManager.func_179121_F();
			}
		}
	}
}
