package forestry.book.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.minecraft.client.gui.GuiButton;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IForesterBook;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonEntry;
import forestry.book.gui.buttons.GuiButtonPage;

@SideOnly(Side.CLIENT)
public class GuiForestryBookEntries extends GuiForesterBook {
	private final IBookCategory category;
	private int entryIndex = 0;

	public GuiForestryBookEntries(IForesterBook book, IBookCategory category) {
		super(book);
		this.category = category;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		int offset = entryIndex * 24;
		addEntryButtons(offset, LEFT_PAGE_START_X, LEFT_PAGE_START_Y);
		addEntryButtons(offset + 12, RIGHT_PAGE_START_X, RIGHT_PAGE_START_Y);
		elementManager.init(guiLeft, guiTop);
		elementManager.clear();
	}

	private void addEntryButtons(int indexStart, int xStart, int yStart){
		List<IBookEntry> entries = new ArrayList<>(category.getEntries());
		if(indexStart >= entries.size()){
			return;
		}
		final int maxIndex;
		if(entries.size() > indexStart + 12){
			maxIndex = indexStart + 12;
		}else{
			maxIndex = entries.size();
		}
		int yOffset = 0;
		for(int i = indexStart;i < maxIndex;i++){
			IBookEntry entry = entries.get(i);
			func_189646_b(new GuiButtonEntry(field_146292_n.size(), guiLeft + xStart, guiTop + yStart + yOffset, entry));
			yOffset += field_146289_q.field_78288_b + 2;
		}
	}

	@Override
	protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
		leftButton.field_146125_m = entryIndex > 0;
		rightButton.field_146125_m = category.getEntries().size() > (entryIndex + 1) * 24;
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if (button instanceof GuiButtonPage) {
			GuiButtonPage pageButton = (GuiButtonPage) button;
			if (pageButton.left) {
				entryIndex--;
			} else {
				entryIndex++;
			}
			func_73866_w_();
		} else if (button instanceof GuiButtonBack) {
			displayCategories();
		} else if (button instanceof GuiButtonEntry) {
			GuiButtonEntry entry = (GuiButtonEntry) button;
			field_146297_k.func_147108_a(new GuiForestryBookPages(book, category, entry.entry, null));
		}
	}

	@Override
	protected List<String> getTooltip(int mouseX, int mouseY) {
		return elementManager.getTooltip(mouseX, mouseY);
	}

	private void displayCategories() {
		field_146297_k.func_147108_a(new GuiForestryBookCategories(book));
	}

	@Override
	protected String getTitle() {
		return category.getLocalizedName();
	}
}
