package forestry.arboriculture.blocks;

import java.util.Collection;

import net.minecraft.block.BlockLog;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.proxy.ProxyArboricultureClient;

import net.minecraft.block.BlockLog.EnumAxis;

public abstract class BlockForestryLog<T extends Enum<T> & IWoodType> extends BlockLog implements IWoodTyped, IStateMapperRegister, IItemModelRegister {
	protected static final int VARIANTS_PER_BLOCK = 4;

	private final boolean fireproof;
	private final int blockNumber;

	protected BlockForestryLog(boolean fireproof, int blockNumber) {
		this.fireproof = fireproof;
		this.blockNumber = blockNumber;

		PropertyWoodType<T> variant = getVariant();
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(variant, variant.getFirstType()).func_177226_a(field_176299_a, EnumAxis.Y));

		setHarvestLevel("axe", 0);
		func_149647_a(Tabs.tabArboriculture);
	}


	@Override
	public final WoodBlockKind getBlockKind() {
		return WoodBlockKind.LOG;
	}

	@Override
	public final boolean isFireproof() {
		return fireproof;
	}

	public final int getBlockNumber() {
		return blockNumber;
	}

	private static EnumAxis getAxis(int meta) {
		switch (meta & 12) {
			case 0:
				return EnumAxis.Y;
			case 4:
				return EnumAxis.X;
			case 8:
				return EnumAxis.Z;
			default:
				return EnumAxis.NONE;
		}
	}

	@Override
	public final IBlockState func_176203_a(int meta) {
		T woodType = getWoodType(meta);
		EnumAxis axis = getAxis(meta);
		return func_176223_P().func_177226_a(getVariant(), woodType).func_177226_a(field_176299_a, axis);
	}

	@SuppressWarnings("incomplete-switch")
	@Override
	public final int func_176201_c(IBlockState state) {
		int i = func_180651_a(state);

		switch (state.func_177229_b(field_176299_a)) {
			case X:
				i |= 4;
				break;
			case Z:
				i |= 8;
				break;
			case NONE:
				i |= 12;
		}

		return i;
	}

	public abstract PropertyWoodType<T> getVariant();

	@Override
	public abstract T getWoodType(int meta);

	@Override
	public final Collection<T> getWoodTypes() {
		return getVariant().func_177700_c();
	}

	@Override
	protected final BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, getVariant(), field_176299_a);
	}

	@Override
	public final int func_180651_a(IBlockState state) {
		return state.func_177229_b(getVariant()).getMetadata() - blockNumber * VARIANTS_PER_BLOCK;
	}

	@Override
	public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
		EnumAxis axis = EnumAxis.func_176870_a(facing.func_176740_k());
		T woodType = getWoodType(meta);
		return func_176223_P().func_177226_a(getVariant(), woodType).func_177226_a(field_176299_a, axis);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (T woodType : getVariant().func_177700_c()) {
			list.add(TreeManager.woodAccess.getStack(woodType, getBlockKind(), fireproof));
		}
	}

	@Override
	public final float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
		int meta = func_176201_c(blockState);
		T woodType = getWoodType(meta);
		return woodType.getHardness();
	}

	@Override
	protected ItemStack func_180643_i(IBlockState state) {
		ItemStack silkTouchDrop = super.func_180643_i(state);
		int damage = this.func_180651_a(state);
		silkTouchDrop.func_77964_b(damage);
		return silkTouchDrop;
	}

	/* PROPERTIES */
	@Override
	public final int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		if (fireproof) {
			return 0;
		} else if (face == EnumFacing.DOWN) {
			return 20;
		} else if (face != EnumFacing.UP) {
			return 10;
		} else {
			return 5;
		}
	}

	@Override
	public final int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		if (fireproof) {
			return 0;
		}
		return 5;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public final void registerModel(Item item, IModelManager manager) {
		ModelBakery.registerItemVariants(item, WoodHelper.getDefaultResourceLocations(this));
		ProxyArboricultureClient.registerWoodMeshDefinition(item, new WoodHelper.WoodMeshDefinition(this));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public final void registerStateMapper() {
		ProxyArboricultureClient.registerWoodStateMapper(this, new WoodTypeStateMapper(this, getVariant()));
	}
}
