/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.api.gui.GuiElementAlignment;
import forestry.book.data.IndexEntry;
import forestry.book.gui.GuiForesterBook;
import forestry.book.gui.GuiForestryBookPages;
import forestry.core.gui.elements.TextElement;
import forestry.core.gui.elements.layouts.VerticalLayout;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IndexElement
extends VerticalLayout {
    public IndexElement(int xPos, int yPos, IndexEntry[] data) {
        super(xPos, yPos, 108);
        for (IndexEntry index : data) {
            this.add(new IndexEntryElement(index));
        }
    }

    private class IndexEntryElement
    extends TextElement {
        private final IndexEntry data;

        public IndexEntryElement(IndexEntry data) {
            super(-1, 9, data.title, GuiElementAlignment.TOP_LEFT, 0, true);
            this.width += TextElement.FONT_RENDERER.func_78256_a(" > ");
            this.data = data;
        }

        @Override
        public void drawElement(int mouseX, int mouseY) {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            boolean unicode = FONT_RENDERER.func_82883_a();
            String preFix = mouseOver ? TextFormatting.GOLD + " > " : TextFormatting.DARK_GRAY + "- ";
            FONT_RENDERER.func_78264_a(this.unicode);
            FONT_RENDERER.func_78276_b(preFix + this.text, 0, 0, this.color);
            FONT_RENDERER.func_78264_a(unicode);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            GuiForesterBook bookGui = GuiForesterBook.getGuiScreen();
            if (bookGui instanceof GuiForestryBookPages) {
                GuiForestryBookPages pagesGui = (GuiForestryBookPages)bookGui;
                pagesGui.switchPage(this.data.page);
            }
        }
    }
}

