package forestry.core.gui;

import javax.annotation.Nullable;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.ModuleCore;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.database.inventory.InventoryDatabaseAnalyzer;
import forestry.modules.ForestryModuleUids;
import forestry.modules.ModuleHelper;

public class ContainerAnalyzerProvider<T extends TileEntity> extends ContainerTile<T> implements IGuiSelectable {
	/* Attributes - Final*/
	private final EntityPlayer player;
	@Nullable
	private final ItemInventoryAlyzer alyzerInventory;
	private final int analyzerIndex;

	/* Constructors */
	public ContainerAnalyzerProvider(T tileForestry, InventoryPlayer playerInventory, int xInv, int yInv) {
		super(tileForestry, playerInventory, xInv, yInv);

		this.player = playerInventory.field_70458_d;

		ItemInventoryAlyzer alyzerInventory = null;
		int analyzerIndex = -1;
		for(int i = 0;i < playerInventory.func_70302_i_();i++){
			ItemStack stack = playerInventory.func_70301_a(i);
			if(stack.func_190926_b() || stack.func_77973_b() != ModuleCore.getItems().portableAlyzer){
				continue;
			}
			analyzerIndex = i;
			alyzerInventory = new ItemInventoryAlyzer(playerInventory.field_70458_d, stack);
			Slot slot = func_75147_a(playerInventory, i);
			if(slot instanceof SlotLockable){
				SlotLockable lockable = (SlotLockable) slot;
				lockable.lock();
			}
			break;
		}
		this.analyzerIndex = analyzerIndex;
		this.alyzerInventory = alyzerInventory;

		if(alyzerInventory != null) {
			func_75146_a(new SlotAnalyzer(alyzerInventory, ItemInventoryAlyzer.SLOT_ENERGY, -110, 20));
		}

	}

	/* Methods */
	@Nullable
	public Slot getAnalyzerSlot(){
		if(alyzerInventory == null){
			return null;
		}
		return func_75147_a(alyzerInventory, 0);
	}

	private ItemStack analyzeSpecimen(int selectedSlot) {
		if(selectedSlot < 0 || alyzerInventory == null){
			return ItemStack.field_190927_a;
		}
		Slot specimenSlot = getForestrySlot( selectedSlot);
		ItemStack specimen = specimenSlot.func_75211_c();
		if (specimen.func_190926_b()) {
			return ItemStack.field_190927_a;
		}

		ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
		if (!ItemStack.func_77989_b(specimen, convertedSpecimen)) {
			specimenSlot.func_75215_d(convertedSpecimen);
			specimen = convertedSpecimen;
		}

		ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen);

		// No individual, abort
		if (speciesRoot == null) {
			return specimen;
		}

		IIndividual individual = speciesRoot.getMember(specimen);

		// Analyze if necessary
		if (individual != null && !individual.isAnalyzed()) {
			final boolean requiresEnergy = ModuleHelper.isEnabled(ForestryModuleUids.APICULTURE);
			if (requiresEnergy) {
				// Requires energy
				if (!ItemInventoryAlyzer.isAlyzingFuel(alyzerInventory.func_70301_a(InventoryDatabaseAnalyzer.SLOT_ENERGY))) {
					return specimen;
				}
			}

			if (individual.analyze()) {
				IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
				breedingTracker.registerSpecies(individual.getGenome().getPrimary());
				breedingTracker.registerSpecies(individual.getGenome().getSecondary());

				NBTTagCompound nbttagcompound = new NBTTagCompound();
				individual.writeToNBT(nbttagcompound);
				specimen.func_77982_d(nbttagcompound);

				if (requiresEnergy) {
					// Decrease energy
					alyzerInventory.func_70298_a(InventoryDatabaseAnalyzer.SLOT_ENERGY, 1);
				}
			}
			specimenSlot.func_75215_d(specimen);
		}
		return specimen;
	}

	/* Methods - Implement ContainerForestry */
	@Override
	protected void addSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
		func_75146_a(new SlotLockable(playerInventory, slot, x, y));
	}

	@Override
	protected void addHotbarSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
		func_75146_a(new SlotLockable(playerInventory, slot, x, y));
	}

	/* Methods - Implement IGuiSelectable */
	@Override
	public void handleSelectionRequest(EntityPlayerMP player, int primary, int secondary) {
		analyzeSpecimen(secondary);
	}
}
