/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.network.packets;

import forestry.api.climate.IClimateState;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketSelectClimateTargeted
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final IClimateState climateState;

    public PacketSelectClimateTargeted(BlockPos pos, IClimateState climateState) {
        this.pos = pos;
        this.climateState = climateState;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.SELECT_CLIMATE_TARGETED;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeClimateState(this.climateState);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            BlockPos pos = data.func_179259_c();
            IClimateState climateState = data.readClimateState();
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)player.field_70170_p, pos, IGreenhouseComponent.class);
            if (controller != null) {
                IClimateContainer container = controller.getClimateContainer();
                container.setTargetedState(climateState);
            }
        }
    }
}

