/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IElementLayoutHelper;
import forestry.api.gui.IGuiElement;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.DrawableElement;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.TextElement;
import forestry.core.gui.elements.layouts.AbstractElementLayout;
import forestry.core.gui.elements.layouts.ElementLayoutHelper;
import forestry.core.gui.elements.layouts.HorizontalLayout;
import forestry.core.gui.elements.layouts.PaneLayout;
import forestry.core.gui.elements.layouts.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class ElementGroup
extends GuiElement
implements IElementGroup {
    protected final List<IGuiElement> elements = new ArrayList<IGuiElement>();

    protected ElementGroup(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    @Override
    public <E extends IGuiElement> E add(E element) {
        this.elements.add(element);
        element.setParent(this);
        return element;
    }

    @Override
    public <E extends IGuiElement> E remove(E element) {
        this.elements.remove(element);
        return element;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public List<IGuiElement> getElements() {
        return this.elements;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.forEach(element -> element.draw(mX, mY));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.stream().filter(element -> element.isMouseOver(mX, mY)).forEach(element -> element.mouseClicked(mX, mY, mouseButton));
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.stream().filter(element -> element.isMouseOver(mX, mY)).forEach(element -> element.mouseReleased(mX, mY, mouseButton));
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.stream().filter(element -> element.isMouseOver(mX, mY)).forEach(element -> element.mouseClickMove(mX, mY, mouseButton));
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        return this.elements.stream().anyMatch(element -> element.keyTyped(typedChar, keyCode));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        mouseX -= this.getX();
        mouseY -= this.getY();
        for (IGuiElement element : this.elements) {
            List<String> tooltip;
            if (!element.isMouseOver(mouseX, mouseY) || (tooltip = element.getTooltip(mouseX, mouseY)).isEmpty()) continue;
            return tooltip;
        }
        return this.tooltip;
    }

    @Override
    @Nullable
    public IGuiElement getLastElement() {
        return this.elements.isEmpty() ? null : this.elements.get(this.elements.size() - 1);
    }

    public DrawableElement drawable(Drawable drawable) {
        return this.add((E)new DrawableElement(drawable));
    }

    public DrawableElement drawable(int x, int y, Drawable drawable) {
        return this.add((E)new DrawableElement(x, y, drawable));
    }

    @Override
    public IGuiElement item(int xPos, int yPos, ItemStack itemStack) {
        ItemElement element = new ItemElement(xPos, yPos, itemStack);
        this.add((E)element);
        return element;
    }

    @Override
    public IGuiElement text(String text) {
        return this.text(0, text, 0xFFFFFF);
    }

    @Override
    public IGuiElement text(String text, int color) {
        return this.text(0, text, color);
    }

    @Override
    public IGuiElement text(String text, GuiElementAlignment align) {
        return this.text(text, align, 0xFFFFFF);
    }

    @Override
    public IGuiElement text(String text, GuiElementAlignment align, int color, boolean unicode) {
        return this.text(0, 12, text, align, color, unicode);
    }

    @Override
    public IGuiElement text(String text, GuiElementAlignment align, int color) {
        return this.text(0, text, align, color);
    }

    public IGuiElement text(int x, String text, int color) {
        return this.text(x, text, GuiElementAlignment.TOP_LEFT, color);
    }

    @Override
    public IGuiElement text(int x, String text, GuiElementAlignment align, int color) {
        return this.text(x, 12, text, align, color);
    }

    @Override
    public IGuiElement text(int x, int height, String text, GuiElementAlignment align, int color) {
        return this.text(x, height, text, align, color, false);
    }

    @Override
    public IGuiElement text(int x, int y, int width, int height, String text) {
        return this.add((E)new TextElement(x, y, width, height, text, GuiElementAlignment.TOP_LEFT, 0xFFFFFF, false));
    }

    @Override
    public IGuiElement text(int x, int height, String text, GuiElementAlignment align, int color, boolean unicode) {
        return this.add((E)new TextElement(x, 0, -1, height, text, align, color, unicode));
    }

    @Override
    public AbstractElementLayout vertical(int xPos, int yPos, int width) {
        return this.add((E)new VerticalLayout(xPos, yPos, width));
    }

    @Override
    public AbstractElementLayout vertical(int width) {
        return this.add((E)new VerticalLayout(0, 0, width));
    }

    @Override
    public AbstractElementLayout horizontal(int xPos, int yPos, int height) {
        return this.add((E)new HorizontalLayout(xPos, yPos, height));
    }

    @Override
    public AbstractElementLayout horizontal(int height) {
        return this.add((E)new HorizontalLayout(0, 0, height));
    }

    @Override
    public ElementGroup panel(int xPos, int yPos, int width, int height) {
        return this.add((E)new PaneLayout(xPos, yPos, width, height));
    }

    @Override
    public ElementGroup panel(int width, int height) {
        return this.add((E)new PaneLayout(0, 0, width, height));
    }

    @Override
    public ElementLayoutHelper layoutHelper(IElementLayoutHelper.LayoutFactory layoutFactory, int width, int height) {
        return new ElementLayoutHelper(layoutFactory, width, height, this);
    }
}

