package forestry.core.owner;

import java.util.Optional;
import java.util.UUID;

import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;

import com.mojang.authlib.GameProfile;

public class GameProfileDataSerializer implements DataSerializer<Optional<GameProfile>> {
	public static final GameProfileDataSerializer INSTANCE = new GameProfileDataSerializer();

	public static void register() {
		DataSerializers.func_187189_a(INSTANCE);
	}

	private GameProfileDataSerializer() {

	}

	@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
	@Override
	public void func_187160_a(PacketBuffer buf, Optional<GameProfile> value) {
		if (!value.isPresent()) {
			buf.writeBoolean(false);
		} else {
			buf.writeBoolean(true);
			GameProfile gameProfile = value.get();
			buf.func_179252_a(gameProfile.getId());
			buf.func_180714_a(gameProfile.getName());
		}
	}

	@Override
	public Optional<GameProfile> func_187159_a(PacketBuffer buf) {
		if (buf.readBoolean()) {
			UUID uuid = buf.func_179253_g();
			String name = buf.func_150789_c(1024);
			GameProfile gameProfile = new GameProfile(uuid, name);
			return Optional.of(gameProfile);
		} else {
			return Optional.empty();
		}
	}

	@Override
	public DataParameter<Optional<GameProfile>> func_187161_a(int id) {
		return new DataParameter<>(id, this);
	}
	
	@Override
	public Optional<GameProfile> func_192717_a(Optional<GameProfile> value) {
		return value;
	}
}
