/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei;

import com.google.common.base.Preconditions;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.JeiUtil;
import forestry.factory.ModuleFactory;
import forestry.factory.blocks.BlockRegistryFactory;
import forestry.factory.gui.GuiBottler;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.gui.GuiCentrifuge;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.gui.GuiStill;
import forestry.factory.recipes.jei.bottler.BottlerRecipeCategory;
import forestry.factory.recipes.jei.bottler.BottlerRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeCategory;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeTransferHandler;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeCategory;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeCategory;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeTransferHandler;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeCategory;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeMaker;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeCategory;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeMaker;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeCategory;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeMaker;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeCategory;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeMaker;
import forestry.factory.recipes.jei.still.StillRecipeCategory;
import forestry.factory.recipes.jei.still.StillRecipeMaker;
import forestry.modules.ModuleHelper;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class FactoryJeiPlugin
implements IModPlugin {
    @Nullable
    public static IJeiHelpers jeiHelpers;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!ModuleHelper.isEnabled("factory")) {
            return;
        }
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BottlerRecipeCategory(guiHelper), new CarpenterRecipeCategory(guiHelper), new CentrifugeRecipeCategory(guiHelper), new FabricatorRecipeCategory(guiHelper), new FermenterRecipeCategory(guiHelper), new MoistenerRecipeCategory(guiHelper), new RainmakerRecipeCategory(guiHelper), new SqueezerRecipeCategory(guiHelper), new StillRecipeCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new ForestryAdvancedGuiHandler()});
        if (!ModuleHelper.isEnabled("factory")) {
            return;
        }
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipes(BottlerRecipeMaker.getBottlerRecipes(registry.getIngredientRegistry()), "forestry.bottler");
        registry.addRecipes(CarpenterRecipeMaker.getCarpenterRecipes(), "forestry.carpenter");
        registry.addRecipes(CentrifugeRecipeMaker.getCentrifugeRecipe(), "forestry.centrifuge");
        registry.addRecipes(FabricatorRecipeMaker.getFabricatorRecipes(), "forestry.fabricator");
        registry.addRecipes(FermenterRecipeMaker.getFermenterRecipes(jeiHelpers.getStackHelper()), "forestry.fermenter");
        registry.addRecipes(MoistenerRecipeMaker.getMoistenerRecipes(), "forestry.moistener");
        registry.addRecipes(RainmakerRecipeMaker.getRecipes(), "forestry.rainmaker");
        registry.addRecipes(SqueezerRecipeMaker.getSqueezerRecipes(), "forestry.squeezer");
        registry.addRecipes(SqueezerRecipeMaker.getSqueezerContainerRecipes(registry.getIngredientRegistry()), "forestry.squeezer");
        registry.addRecipes(StillRecipeMaker.getStillRecipes(), "forestry.still");
        registry.addRecipeClickArea(GuiBottler.class, 107, 33, 26, 22, new String[]{"forestry.bottler"});
        registry.addRecipeClickArea(GuiBottler.class, 45, 33, 26, 22, new String[]{"forestry.bottler"});
        registry.addRecipeClickArea(GuiCarpenter.class, 98, 48, 21, 26, new String[]{"forestry.carpenter"});
        registry.addRecipeClickArea(GuiCentrifuge.class, 38, 22, 38, 14, new String[]{"forestry.centrifuge"});
        registry.addRecipeClickArea(GuiCentrifuge.class, 38, 54, 38, 14, new String[]{"forestry.centrifuge"});
        registry.addRecipeClickArea(GuiFabricator.class, 121, 53, 18, 18, new String[]{"forestry.fabricator"});
        registry.addRecipeClickArea(GuiFermenter.class, 72, 40, 32, 18, new String[]{"forestry.fermenter"});
        registry.addRecipeClickArea(GuiMoistener.class, 123, 35, 19, 21, new String[]{"forestry.moistener"});
        registry.addRecipeClickArea(GuiSqueezer.class, 76, 41, 43, 16, new String[]{"forestry.squeezer"});
        registry.addRecipeClickArea(GuiStill.class, 73, 17, 33, 57, new String[]{"forestry.still"});
        BlockRegistryFactory blocks = ModuleFactory.getBlocks();
        Preconditions.checkNotNull((Object)blocks);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.bottler), new String[]{"forestry.bottler"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.carpenter), new String[]{"forestry.carpenter"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.centrifuge), new String[]{"forestry.centrifuge"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.fabricator), new String[]{"forestry.fabricator"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.fermenter), new String[]{"forestry.fermenter"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.moistener), new String[]{"forestry.moistener"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.rainmaker), new String[]{"forestry.rainmaker"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.squeezer), new String[]{"forestry.squeezer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)blocks.still), new String[]{"forestry.still"});
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CarpenterRecipeTransferHandler(), "forestry.carpenter");
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new FabricatorRecipeTransferHandler(), "forestry.fabricator");
        JeiUtil.addDescription(registry, blocks.raintank);
    }

    private static class ForestryAdvancedGuiHandler
    implements IAdvancedGuiHandler<GuiForestry> {
        private ForestryAdvancedGuiHandler() {
        }

        public Class<GuiForestry> getGuiContainerClass() {
            return GuiForestry.class;
        }

        @Nullable
        public List<Rectangle> getGuiExtraAreas(GuiForestry guiContainer) {
            return guiContainer.getExtraGuiAreas();
        }

        @Nullable
        public Object getIngredientUnderMouse(GuiForestry guiContainer, int mouseX, int mouseY) {
            return guiContainer.getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

