/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.IModelBaker;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDefaultLeaves
extends ModelBlockCached<BlockDefaultLeaves, TreeDefinition> {
    public ModelDefaultLeaves() {
        super(BlockDefaultLeaves.class);
    }

    @Override
    protected TreeDefinition getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)(block instanceof BlockDefaultLeaves), (Object)"ItemStack must be for default leaves.");
        BlockDefaultLeaves bBlock = (BlockDefaultLeaves)block;
        return bBlock.getTreeType(stack.func_77960_j());
    }

    @Override
    protected TreeDefinition getWorldKey(IBlockState state) {
        Block block = state.func_177230_c();
        Preconditions.checkArgument((boolean)(block instanceof BlockDefaultLeaves), (Object)"state must be for default leaves.");
        BlockDefaultLeaves bBlock = (BlockDefaultLeaves)block;
        TreeDefinition treeDefinition = bBlock.getTreeDefinition(state);
        Preconditions.checkNotNull((Object)treeDefinition);
        return treeDefinition;
    }

    @Override
    protected void bakeBlock(BlockDefaultLeaves block, TreeDefinition treeDefinition, IModelBaker baker, boolean inventory) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        ITreeGenome genome = treeDefinition.getGenome();
        IAlleleTreeSpecies species = genome.getPrimary();
        ILeafSpriteProvider leafSpriteProvider = species.getLeafSpriteProvider();
        ResourceLocation leafSpriteLocation = leafSpriteProvider.getSprite(false, Proxies.render.fancyGraphicsEnabled());
        TextureAtlasSprite leafSprite = map.func_110572_b(leafSpriteLocation.toString());
        baker.addBlockModel(null, leafSprite, 0);
        ResourceLocation fruitSpriteLocation = genome.getFruitProvider().getDecorativeSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel(null, fruitSprite, 2);
        }
        baker.setParticleSprite(leafSprite);
    }

    @Override
    protected IBakedModel bakeModel(IBlockState state, TreeDefinition key, BlockDefaultLeaves block) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, key, (IModelBaker)baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }
}

