package forestry.book.gui;

import javax.annotation.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.book.IForesterBook;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonPage;
import forestry.core.config.Constants;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.ElementManager;

@SideOnly(Side.CLIENT)
public abstract class GuiForesterBook extends GuiScreen implements IGuiSizable {
	public static final ResourceLocation TEXTURE = new ResourceLocation(Constants.MOD_ID, Constants.TEXTURE_PATH_GUI + "/almanac/almanac.png");
	static final int LEFT_PAGE_START_X = 16;
	static final int RIGHT_PAGE_START_X = 132;
	static final int PAGE_START_Y = 12;
	static final int LEFT_PAGE_START_Y = 25;
	static final int RIGHT_PAGE_START_Y = PAGE_START_Y;
	public static final int PAGE_WIDTH = 108;
	public static final int PAGE_HEIGHT = 155;

	private static final int X_SIZE = 256;
	private static final int Y_SIZE = 181;
	@Nullable
	private static GuiForesterBook guiScreen;
	protected final IForesterBook book;
	final ElementManager<GuiForesterBook> elementManager;

	protected int guiLeft;
	protected int guiTop;

	protected GuiForesterBook(IForesterBook book) {
		this.book = book;
		setGuiScreen(this);
		this.elementManager = new ElementManager<>(this);
	}

	public IForesterBook getBook() {
		return book;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.guiLeft = (this.field_146294_l - X_SIZE) / 2;
		this.guiTop = (this.field_146295_m - Y_SIZE) / 2;
		elementManager.init(guiLeft, guiTop);
		this.field_146292_n.clear();
		if (hasButtons()) {
			GuiButtonPage leftButton = func_189646_b(new GuiButtonPage(0, guiLeft + 24, guiTop + Y_SIZE - 20, true));
			GuiButtonPage rightButton = func_189646_b(new GuiButtonPage(1, guiLeft + X_SIZE - 44, guiTop + Y_SIZE - 20, false));
			GuiButtonBack backButton = func_189646_b(new GuiButtonBack(2, guiLeft + X_SIZE / 2 - 12, guiTop + Y_SIZE - 20));
			initButtons(leftButton, rightButton, backButton);
		}
	}

	protected boolean hasButtons() {
		return true;
	}

	protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
	}

	@Override
	public boolean func_73868_f() {
		return false;
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		TextureManager manager = field_146297_k.field_71446_o;

		manager.func_110577_a(TEXTURE);
		func_73729_b(guiLeft, guiTop, 0, 0, X_SIZE, Y_SIZE);

		super.func_73863_a(mouseX, mouseY, partialTicks);

		boolean unicode = field_146289_q.func_82883_a();
		field_146289_q.func_78264_a(true);
		func_73732_a(field_146289_q, TextFormatting.UNDERLINE + getTitle(), guiLeft + LEFT_PAGE_START_X + 52, guiTop + PAGE_START_Y, 0xD3D3D3);

		drawText();

		field_146289_q.func_78264_a(unicode);

		elementManager.draw(mouseX, mouseY);

		InventoryPlayer playerInv = field_146297_k.field_71439_g.field_71071_by;

		if (playerInv.func_70445_o().func_190926_b()) {
			GuiUtil.drawToolTips(this, field_146292_n, mouseX, mouseY);
			elementManager.drawTooltip(mouseX, mouseY);
			List<String> tooltip = getTooltip(mouseX, mouseY);
			if (!tooltip.isEmpty()) {
				ScaledResolution scaledresolution = new ScaledResolution(field_146297_k);
				GuiUtils.drawHoveringText(tooltip, mouseX, mouseY, scaledresolution.func_78326_a(), scaledresolution.func_78328_b(), -1, field_146289_q);
			}
		}
	}

	protected void drawText() {
	}

	protected List<String> getTooltip(int mouseX, int mouseY) {
		return Collections.emptyList();
	}

	protected abstract String getTitle();

	@Override
	protected void func_73869_a(char typedChar, int keyCode) throws IOException {
		if (elementManager.keyTyped(typedChar, keyCode)) {
			return;
		}
		super.func_73869_a(typedChar, keyCode);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.func_73864_a(mouseX, mouseY, mouseButton);
		elementManager.mouseClicked(mouseX, mouseY, mouseButton);
	}

	@Override
	protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
		super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
		elementManager.mouseClickMove(mouseX, mouseY, clickedMouseButton);
	}

	@Override
	protected void func_146286_b(int mouseX, int mouseY, int state) {
		super.func_146286_b(mouseX, mouseY, state);
		elementManager.mouseReleased(mouseX, mouseY, state);
	}

	@Override
	public int getGuiLeft() {
		return guiLeft;
	}

	@Override
	public int getGuiTop() {
		return guiTop;
	}

	@Override
	public int getSizeX() {
		return X_SIZE;
	}

	@Override
	public int getSizeY() {
		return Y_SIZE;
	}

	@Override
	public Minecraft getMC() {
		return field_146297_k;
	}

	@Nullable
	public static GuiForesterBook getGuiScreen() {
		return guiScreen;
	}

	public static void setGuiScreen(@Nullable GuiForesterBook guiScreen) {
		GuiForesterBook.guiScreen = guiScreen;
	}
}
