/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

/**
 * Created by CovertJaguar on 3/6/2016 for Railcraft.
 */
public abstract class InvWrapperBase implements IInventory {

	private final IInventory inv;
	private boolean checkItems = true;

	public InvWrapperBase(IInventory inv) {
		this(inv, true);
	}

	public InvWrapperBase(IInventory inv, boolean checkItems) {
		this.inv = inv;
		this.checkItems = checkItems;
	}

	public IInventory getBaseInventory() {
		return inv;
	}

	@Override
	public int func_70302_i_() {
		return inv.func_70302_i_();
	}

	@Override
	public ItemStack func_70301_a(int slot) {
		return inv.func_70301_a(slot);
	}

	@Override
	public ItemStack func_70298_a(int slot, int amount) {
		return inv.func_70298_a(slot, amount);
	}

	@Override
	public ItemStack func_70304_b(int slot) {
		return inv.func_70304_b(slot);
	}

	@Override
	public void func_70299_a(int slot, ItemStack itemstack) {
		inv.func_70299_a(slot, itemstack);
	}

	@Override
	public String func_70005_c_() {
		return inv.func_70005_c_();
	}

	@Override
	public ITextComponent func_145748_c_() {
		return inv.func_145748_c_();
	}

	@Override
	public int func_70297_j_() {
		return inv.func_70297_j_();
	}

	@Override
	public void func_70296_d() {
		inv.func_70296_d();
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer) {
		return inv.func_70300_a(entityplayer);
	}

	@Override
	public void func_174889_b(EntityPlayer player) {
		inv.func_174889_b(player);
	}

	@Override
	public void func_174886_c(EntityPlayer player) {
		inv.func_174886_c(player);
	}

	@Override
	public boolean func_145818_k_() {
		return inv.func_145818_k_();
	}

	@Override
	public boolean func_94041_b(int slot, ItemStack stack) {
		return !checkItems || inv.func_94041_b(slot, stack);
	}

	@Override
	public int func_174887_a_(int id) {
		return inv.func_174887_a_(id);
	}

	@Override
	public void func_174885_b(int id, int value) {
		inv.func_174885_b(id, value);
	}

	@Override
	public int func_174890_g() {
		return inv.func_174890_g();
	}

	@Override
	public void func_174888_l() {
		inv.func_174888_l();
	}

	public boolean checkItems() {
		return checkItems;
	}
}

