/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimateManager;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateState;
import forestry.core.DefaultClimateProvider;
import forestry.core.climate.ClimateInfo;
import forestry.core.climate.ClimateStates;
import forestry.core.climate.ClimateWorldManager;
import forestry.core.utils.World2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ClimateManager
implements IClimateManager {
    private static final ClimateManager INSTANCE = new ClimateManager();
    private static final Map<Biome, IClimateState> BIOME_STATES = new HashMap<Biome, IClimateState>();
    private final World2ObjectMap<ClimateWorldManager> managers = new World2ObjectMap(world -> new ClimateWorldManager(this));

    private ClimateManager() {
    }

    public static ClimateManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IClimateInfo createInfo(float temperature, float humidity) {
        return new ClimateInfo(temperature, humidity);
    }

    @Override
    public IClimateInfo getInfo(World world, BlockPos pos) {
        return new ClimateInfo(this.getBiomeState(world, pos));
    }

    @Override
    public IClimateState getBiomeState(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        return this.getBiomeState(biome);
    }

    private IClimateState getBiomeState(Biome biome) {
        if (!BIOME_STATES.containsKey(biome)) {
            BIOME_STATES.put(biome, ClimateStates.of(biome.func_185353_n(), biome.func_76727_i()));
        }
        return BIOME_STATES.get(biome);
    }

    @Override
    public IClimateState getClimateState(World world, BlockPos pos) {
        ClimateWorldManager manager = this.managers.get(world);
        if (manager == null) {
            return this.getBiomeState(world, pos);
        }
        return manager.getClimateState(world, pos);
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }
}

